/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.zuul;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import io.opentracing.Span;
import io.opentracing.contrib.spring.cloud.zuul.TracePreZuulFilter;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;

public class TracePostZuulFilter
extends ZuulFilter {
    static final String ROUTE_HOST_TAG = "route.host";

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Object spanObject = ctx.get((Object)TracePreZuulFilter.CONTEXT_SPAN_KEY);
        if (spanObject instanceof Span) {
            Span span = (Span)spanObject;
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)ctx.getResponseStatusCode());
            if (ctx.getThrowable() != null) {
                TracePostZuulFilter.onError(ctx.getThrowable(), span);
            } else {
                Object error = ctx.get((Object)"error.exception");
                if (error instanceof Exception) {
                    TracePostZuulFilter.onError((Exception)error, span);
                }
            }
            if (ctx.getRouteHost() != null) {
                span.setTag(ROUTE_HOST_TAG, ctx.getRouteHost().toString());
            }
            span.finish();
        }
        return null;
    }

    private static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(TracePostZuulFilter.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        return errorLogs;
    }
}

