/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.java.spring.jaeger.starter;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="opentracing.jaeger")
public class JaegerConfigurationProperties {
    private final RemoteReporter remoteReporter = new RemoteReporter();
    private final HttpSender httpSender = new HttpSender();
    private final UdpSender udpSender = new UdpSender();
    private final ConstSampler constSampler = new ConstSampler();
    private final ProbabilisticSampler probabilisticSampler = new ProbabilisticSampler();
    private final RateLimitingSampler rateLimitingSampler = new RateLimitingSampler();
    private final RemoteControlledSampler remoteControlledSampler = new RemoteControlledSampler();
    private boolean enabled = true;
    private boolean logSpans = true;
    private boolean enableB3Propagation = false;
    private boolean expandExceptionLogs = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLogSpans() {
        return this.logSpans;
    }

    public void setLogSpans(boolean logSpans) {
        this.logSpans = logSpans;
    }

    public boolean isEnableB3Propagation() {
        return this.enableB3Propagation;
    }

    public void setEnableB3Propagation(boolean enableB3Propagation) {
        this.enableB3Propagation = enableB3Propagation;
    }

    public boolean isExpandExceptionLogs() {
        return this.expandExceptionLogs;
    }

    public void setExpandExceptionLogs(boolean expandExceptionLogs) {
        this.expandExceptionLogs = expandExceptionLogs;
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public RemoteReporter getRemoteReporter() {
        return this.remoteReporter;
    }

    public UdpSender getUdpSender() {
        return this.udpSender;
    }

    public ConstSampler getConstSampler() {
        return this.constSampler;
    }

    public ProbabilisticSampler getProbabilisticSampler() {
        return this.probabilisticSampler;
    }

    public RateLimitingSampler getRateLimitingSampler() {
        return this.rateLimitingSampler;
    }

    public RemoteControlledSampler getRemoteControlledSampler() {
        return this.remoteControlledSampler;
    }

    public static class RemoteControlledSampler {
        private String hostPort;
        private Double samplingRate = 0.001;

        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
        }

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class RateLimitingSampler {
        private Double maxTracesPerSecond;

        public Double getMaxTracesPerSecond() {
            return this.maxTracesPerSecond;
        }

        public void setMaxTracesPerSecond(Double maxTracesPerSecond) {
            this.maxTracesPerSecond = maxTracesPerSecond;
        }
    }

    public static class ProbabilisticSampler {
        private Double samplingRate;

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class ConstSampler {
        private Boolean decision;

        public Boolean getDecision() {
            return this.decision;
        }

        public void setDecision(Boolean decision) {
            this.decision = decision;
        }
    }

    public static class UdpSender {
        private String host = "localhost";
        private int port = 6831;
        private int maxPacketSize = 0;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getMaxPacketSize() {
            return this.maxPacketSize;
        }

        public void setMaxPacketSize(int maxPacketSize) {
            this.maxPacketSize = maxPacketSize;
        }
    }

    public static class HttpSender {
        private String url;
        private Integer maxPayload = 0;
        private String username;
        private String password;
        private String authToken;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getMaxPayload() {
            return this.maxPayload;
        }

        public void setMaxPayload(Integer maxPayload) {
            this.maxPayload = maxPayload;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }
    }

    public static class RemoteReporter {
        private Integer flushInterval;
        private Integer maxQueueSize;

        public Integer getFlushInterval() {
            return this.flushInterval;
        }

        public void setFlushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }
    }
}

