/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.java.spring.jaeger.starter;

import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.internal.reporters.CompositeReporter;
import io.jaegertracing.internal.reporters.LoggingReporter;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.internal.samplers.HttpSamplingManager;
import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.RateLimitingSampler;
import io.jaegertracing.internal.samplers.RemoteControlledSampler;
import io.jaegertracing.spi.MetricsFactory;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.SamplingManager;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.UdpSender;
import io.opentracing.Tracer;
import io.opentracing.contrib.java.spring.jaeger.starter.JaegerConfigurationProperties;
import io.opentracing.contrib.java.spring.jaeger.starter.ReporterAppender;
import io.opentracing.contrib.java.spring.jaeger.starter.TracerBuilderCustomizer;
import io.opentracing.contrib.java.spring.jaeger.starter.customizers.B3CodecTracerBuilderCustomizer;
import io.opentracing.contrib.java.spring.jaeger.starter.customizers.ExpandExceptionLogsTracerBuilderCustomizer;
import io.opentracing.contrib.java.spring.jaeger.starter.customizers.HigherBitTracerBuilderCustomizer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JaegerTracer.class})
@ConditionalOnMissingBean(value={Tracer.class})
@ConditionalOnProperty(value={"opentracing.jaeger.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={TracerAutoConfiguration.class})
@EnableConfigurationProperties(value={JaegerConfigurationProperties.class})
public class JaegerAutoConfiguration {
    @Autowired(required=false)
    private List<TracerBuilderCustomizer> tracerCustomizers = Collections.emptyList();

    @Bean
    public Tracer tracer(Sampler sampler, Reporter reporter, Metrics metrics, JaegerConfigurationProperties properties) {
        JaegerTracer.Builder builder = new JaegerTracer.Builder(properties.getServiceName()).withReporter(reporter).withSampler(sampler).withTags(properties.determineTags()).withMetrics(metrics);
        this.tracerCustomizers.forEach(c -> c.customize(builder));
        return builder.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public Reporter reporter(JaegerConfigurationProperties properties, Metrics metrics, @Autowired(required=false) ReporterAppender reporterAppender) {
        LinkedList<Reporter> reporters = new LinkedList<Reporter>();
        JaegerConfigurationProperties.RemoteReporter remoteReporter = properties.getRemoteReporter();
        JaegerConfigurationProperties.HttpSender httpSender = properties.getHttpSender();
        if (!StringUtils.isEmpty((Object)httpSender.getUrl())) {
            reporters.add(this.getHttpReporter(metrics, remoteReporter, httpSender));
        } else {
            reporters.add(this.getUdpReporter(metrics, remoteReporter, properties.getUdpSender()));
        }
        if (properties.isLogSpans()) {
            reporters.add((Reporter)new LoggingReporter());
        }
        if (reporterAppender != null) {
            reporterAppender.append(reporters);
        }
        return new CompositeReporter(reporters.toArray(new Reporter[reporters.size()]));
    }

    private Reporter getUdpReporter(Metrics metrics, JaegerConfigurationProperties.RemoteReporter remoteReporter, JaegerConfigurationProperties.UdpSender udpSenderProperties) {
        UdpSender udpSender = new UdpSender(udpSenderProperties.getHost(), udpSenderProperties.getPort(), udpSenderProperties.getMaxPacketSize());
        return this.createReporter(metrics, remoteReporter, (Sender)udpSender);
    }

    private Reporter getHttpReporter(Metrics metrics, JaegerConfigurationProperties.RemoteReporter remoteReporter, JaegerConfigurationProperties.HttpSender httpSenderProperties) {
        HttpSender.Builder builder = new HttpSender.Builder(httpSenderProperties.getUrl());
        if (httpSenderProperties.getMaxPayload() != null) {
            builder = builder.withMaxPacketSize(httpSenderProperties.getMaxPayload().intValue());
        }
        if (!StringUtils.isEmpty((Object)httpSenderProperties.getUsername()) && !StringUtils.isEmpty((Object)httpSenderProperties.getPassword())) {
            builder.withAuth(httpSenderProperties.getUsername(), httpSenderProperties.getPassword());
        } else if (!StringUtils.isEmpty((Object)httpSenderProperties.getAuthToken())) {
            builder.withAuth(httpSenderProperties.getAuthToken());
        }
        return this.createReporter(metrics, remoteReporter, (Sender)builder.build());
    }

    private Reporter createReporter(Metrics metrics, JaegerConfigurationProperties.RemoteReporter remoteReporter, Sender udpSender) {
        RemoteReporter.Builder builder = new RemoteReporter.Builder().withSender(udpSender).withMetrics(metrics);
        if (remoteReporter.getFlushInterval() != null) {
            builder.withFlushInterval(remoteReporter.getFlushInterval().intValue());
        }
        if (remoteReporter.getMaxQueueSize() != null) {
            builder.withMaxQueueSize(remoteReporter.getMaxQueueSize().intValue());
        }
        return builder.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public Metrics metrics(MetricsFactory metricsFactory) {
        return new Metrics(metricsFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public MetricsFactory metricsFactory() {
        return new NoopMetricsFactory();
    }

    @ConditionalOnMissingBean
    @Bean
    public Sampler sampler(JaegerConfigurationProperties properties, Metrics metrics) {
        if (properties.getConstSampler().getDecision() != null) {
            return new ConstSampler(properties.getConstSampler().getDecision().booleanValue());
        }
        if (properties.getProbabilisticSampler().getSamplingRate() != null) {
            return new ProbabilisticSampler(properties.getProbabilisticSampler().getSamplingRate().doubleValue());
        }
        if (properties.getRateLimitingSampler().getMaxTracesPerSecond() != null) {
            return new RateLimitingSampler(properties.getRateLimitingSampler().getMaxTracesPerSecond().doubleValue());
        }
        if (!StringUtils.isEmpty((Object)properties.getRemoteControlledSampler().getHostPort())) {
            JaegerConfigurationProperties.RemoteControlledSampler samplerProperties = properties.getRemoteControlledSampler();
            String hostPort = samplerProperties.getHostPort();
            if (samplerProperties.getHost() != null && !samplerProperties.getHost().isEmpty()) {
                hostPort = samplerProperties.getHost() + ":" + samplerProperties.getPort();
            }
            return new RemoteControlledSampler.Builder(properties.getServiceName()).withSamplingManager((SamplingManager)new HttpSamplingManager(hostPort)).withInitialSampler((Sampler)new ProbabilisticSampler(samplerProperties.getSamplingRate().doubleValue())).withMetrics(metrics).build();
        }
        return new ConstSampler(true);
    }

    @Configuration
    @ConditionalOnProperty(value={"opentracing.jaeger.expand-exception-logs"})
    public static class ExpandExceptionLogsConfiguration {
        @Bean
        public TracerBuilderCustomizer expandExceptionLogsJaegerTracerCustomizer() {
            return new ExpandExceptionLogsTracerBuilderCustomizer();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"opentracing.jaeger.enable-128-bit-traces"})
    public static class HigherBitTraceConfiguration {
        @Bean
        public TracerBuilderCustomizer higherBitJaegerTracerCustomizer() {
            return new HigherBitTracerBuilderCustomizer();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"opentracing.jaeger.enable-b3-propagation"})
    public static class B3CodecConfiguration {
        @Bean
        public TracerBuilderCustomizer b3CodecJaegerTracerCustomizer() {
            return new B3CodecTracerBuilderCustomizer();
        }
    }
}

