/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.integration.messaging;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.integration.messaging.MessageTextMap;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.util.ClassUtils;

public class OpenTracingChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private static final Log log = LogFactory.getLog(OpenTracingChannelInterceptor.class);
    static final String COMPONENT_NAME = "spring-messaging";
    private final Tracer tracer;

    public OpenTracingChannelInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        log.trace((Object)"Processing message before sending it to the channel");
        boolean isConsumer = message.getHeaders().containsKey((Object)"messageSent");
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(this.getOperationName(channel, isConsumer)).withTag(Tags.SPAN_KIND.getKey(), isConsumer ? "consumer" : "producer").withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).withTag(Tags.MESSAGE_BUS_DESTINATION.getKey(), this.getChannelName(channel));
        MessageTextMap carrier = new MessageTextMap(message);
        SpanContext extractedContext = this.tracer.extract(Format.Builtin.TEXT_MAP, carrier);
        if (isConsumer) {
            spanBuilder.addReference("follows_from", extractedContext);
        } else if (this.tracer.activeSpan() == null) {
            spanBuilder.asChildOf(extractedContext);
        }
        Span span = spanBuilder.startActive(true).span();
        if (isConsumer) {
            log.trace((Object)"Adding 'messageConsumed' header");
            carrier.put("messageConsumed", "true");
        } else {
            log.trace((Object)"Adding 'messageSent' header");
            carrier.put("messageSent", "true");
        }
        this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, carrier);
        return carrier.getMessage();
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Scope scope = this.tracer.scopeManager().active();
        if (scope == null) {
            return;
        }
        log.trace((Object)String.format("Completed sending and current span is %s", scope.span()));
        this.handleException(ex, scope.span());
        log.trace((Object)("Closing messaging span scope " + scope));
        scope.close();
        log.trace((Object)String.format("Messaging span scope %s successfully closed", scope));
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        Span span = this.tracer.activeSpan();
        log.trace((Object)String.format("Continuing span %s before handling message", span));
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        Span span = this.tracer.activeSpan();
        log.trace((Object)String.format("Continuing span %s after message handled", span));
        if (span == null) {
            return;
        }
        this.handleException(ex, span);
    }

    protected void handleException(Exception ex, Span span) {
        if (ex != null) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
        }
    }

    protected String getChannelName(MessageChannel messageChannel) {
        String name = null;
        if (ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null)) {
            if (messageChannel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)messageChannel).getComponentName();
            }
            if (name == null && messageChannel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)messageChannel).getFullChannelName();
            }
        }
        if (name == null) {
            return messageChannel.toString();
        }
        return name;
    }

    protected String getOperationName(MessageChannel messageChannel, boolean isConsumer) {
        String channelName = this.getChannelName(messageChannel);
        return String.format("%s:%s", isConsumer ? "receive" : "send", channelName);
    }
}

