/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.integration.messaging;

import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class MessageTextMap<T>
implements TextMap {
    private final Message<T> message;
    private final MutableMessageHeaders headers;
    private final Set<String> byteHeaders;

    public MessageTextMap(Message<T> message) {
        this.message = message;
        this.headers = new MutableMessageHeaders((Map)message.getHeaders());
        this.byteHeaders = new HashSet<String>();
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap stringHeaders = new HashMap(this.headers.size());
        this.headers.forEach((k, v) -> {
            if (v instanceof byte[]) {
                try {
                    stringHeaders.put(k, new String((byte[])v));
                    this.byteHeaders.add((String)k);
                }
                catch (Exception ex) {
                    stringHeaders.put(k, String.valueOf(v));
                }
            } else {
                stringHeaders.put(k, String.valueOf(v));
            }
        });
        return stringHeaders.entrySet().iterator();
    }

    public void put(String key, String value) {
        this.headers.put(key, this.byteHeaders.contains(key) ? (Object)value.getBytes() : value);
    }

    public void addHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public Message<T> getMessage() {
        return MessageBuilder.fromMessage(this.message).copyHeaders((Map)this.headers).build();
    }
}

