/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqBeanPostProcessor;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqReceiveTracingInterceptor;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSendTracingAspect;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSpanDecorator;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

@Configuration
@AutoConfigureAfter(value={RabbitAutoConfiguration.class})
@ConditionalOnClass(value={Message.class, RabbitTemplate.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(name={"opentracing.spring.rabbitmq.enabled"}, havingValue="true", matchIfMissing=true)
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class RabbitMqTracingAutoConfiguration {
    @Autowired
    @Lazy
    private Tracer tracer;

    @ConditionalOnBean(value={RabbitTemplate.class})
    @Bean
    public RabbitMqSendTracingAspect rabbitMqSendTracingAspect(RabbitTemplate rabbitTemplate, RabbitMqSpanDecorator spanDecorator) {
        Assert.notNull((Object)rabbitTemplate.getMessageConverter(), (String)"RabbitTemplate has no message converter configured");
        return new RabbitMqSendTracingAspect(this.tracer, rabbitTemplate.getExchange(), rabbitTemplate.getRoutingKey(), rabbitTemplate.getMessageConverter(), spanDecorator);
    }

    @Bean
    public RabbitMqReceiveTracingInterceptor rabbitMqReceiveTracingInterceptor(RabbitMqSpanDecorator spanDecorator) {
        return new RabbitMqReceiveTracingInterceptor(this.tracer, spanDecorator);
    }

    @Bean
    public RabbitMqBeanPostProcessor rabbitMqBeanPostProcessor(RabbitMqReceiveTracingInterceptor interceptor) {
        return new RabbitMqBeanPostProcessor(interceptor);
    }

    @ConditionalOnMissingBean(value={RabbitMqSpanDecorator.class})
    @Bean
    public RabbitMqSpanDecorator rabbitMqSpanDecorator() {
        return new RabbitMqSpanDecorator();
    }
}

