/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqMessagePropertiesExtractAdapter;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.MessageProperties;

final class RabbitMqTracingUtils {
    private RabbitMqTracingUtils() {
    }

    static Optional<Scope> buildReceiveSpan(MessageProperties messageProperties, Tracer tracer) {
        Optional<SpanContext> context = RabbitMqTracingUtils.findParent(messageProperties, tracer);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("consumer").ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "consumer");
        context.ifPresent(spanContext -> spanBuilder.addReference("follows_from", spanContext));
        Scope scope = spanBuilder.startActive(true);
        return Optional.of(scope);
    }

    static Scope buildSendSpan(Tracer tracer, MessageProperties messageProperties) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("producer").ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "producer");
        ScopeManager scopeManager = tracer.scopeManager();
        Optional<SpanContext> existingSpanContext = Optional.ofNullable(scopeManager).map(ScopeManager::active).map(Scope::span).map(Span::context);
        existingSpanContext.ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
        if (messageProperties.getHeaders() != null) {
            Optional<SpanContext> messageParentContext = RabbitMqTracingUtils.findParent(messageProperties, tracer);
            messageParentContext.ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
        }
        return spanBuilder.startActive(true);
    }

    private static Optional<SpanContext> findParent(MessageProperties messageProperties, Tracer tracer) {
        Map headers = messageProperties.getHeaders();
        SpanContext spanContext = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new RabbitMqMessagePropertiesExtractAdapter(headers));
        if (spanContext == null) {
            return Optional.ofNullable(tracer.activeSpan()).map(Span::context);
        }
        return Optional.of(spanContext);
    }
}

