/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Span;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqTracingTags;
import io.opentracing.tag.Tags;
import java.util.LinkedHashMap;
import org.springframework.amqp.core.MessageProperties;

public class RabbitMqSpanDecorator {
    public void onSend(MessageProperties messageProperties, String exchange, String routingKey, Span span) {
        Tags.COMPONENT.set(span, RabbitMqTracingTags.RABBITMQ.getKey());
        RabbitMqTracingTags.EXCHANGE.set(span, exchange);
        RabbitMqTracingTags.MESSAGE_ID.set(span, messageProperties.getMessageId());
        RabbitMqTracingTags.ROUTING_KEY.set(span, routingKey);
    }

    public void onReceive(MessageProperties messageProperties, Span span) {
        Tags.COMPONENT.set(span, RabbitMqTracingTags.RABBITMQ.getKey());
        RabbitMqTracingTags.EXCHANGE.set(span, messageProperties.getReceivedExchange());
        RabbitMqTracingTags.MESSAGE_ID.set(span, messageProperties.getMessageId());
        RabbitMqTracingTags.ROUTING_KEY.set(span, messageProperties.getReceivedRoutingKey());
        RabbitMqTracingTags.CONSUMER_QUEUE.set(span, messageProperties.getConsumerQueue());
    }

    public void onSendReply(MessageProperties replyMessageProperties, String replyExchange, String replyRoutingKey, Span span) {
    }

    public void onError(Exception ex, Span span) {
        LinkedHashMap<String, Object> exceptionLogs = new LinkedHashMap<String, Object>(2);
        exceptionLogs.put("event", Tags.ERROR.getKey());
        exceptionLogs.put("error.object", ex);
        span.log(exceptionLogs);
        Tags.ERROR.set(span, Boolean.valueOf(true));
    }
}

