/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.starter;

import io.opentracing.contrib.spring.web.starter.WebTracingProperties;
import io.opentracing.contrib.spring.web.webfilter.SkipPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"opentracing.spring.web.enabled"}, havingValue="true", matchIfMissing=true)
public class SkipPatternAutoConfiguration {
    @Autowired(required=false)
    private List<SkipPattern> patterns = new ArrayList<SkipPattern>();

    @Bean(name={"skipPattern"})
    public Pattern skipPattern() {
        return Pattern.compile(this.patterns.stream().map(SkipPattern::pattern).filter(Optional::isPresent).map(Optional::get).map(Pattern::pattern).collect(Collectors.joining("|")));
    }

    @Configuration
    protected static class DefaultSkipPatternConfig {
        protected DefaultSkipPatternConfig() {
        }

        private static String combinedPatterns(String skipPattern) {
            String pattern = skipPattern;
            if (!StringUtils.hasText((String)skipPattern)) {
                pattern = "/api-docs.*|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
            }
            return pattern;
        }

        @Bean
        SkipPattern defaultSkipPatternBean(WebTracingProperties webTracingProperties) {
            return () -> Optional.of(Pattern.compile(DefaultSkipPatternConfig.combinedPatterns(webTracingProperties.getSkipPattern())));
        }
    }

    @Configuration
    @ConditionalOnClass(value={ServerProperties.class, EndpointsSupplier.class, ExposableWebEndpoint.class})
    @ConditionalOnBean(value={ServerProperties.class})
    @ConditionalOnProperty(value={"opentracing.spring.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ActuatorSkipPatternProviderConfig {
        protected ActuatorSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getEndpointsPatterns(String contextPath, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            Collection endpoints = endpointsSupplier.getEndpoints();
            if (endpoints.isEmpty()) {
                return Optional.empty();
            }
            String pattern = endpoints.stream().map(PathMappedEndpoint::getRootPath).map(path -> path + "|" + path + "/.*").collect(Collectors.joining("|", ActuatorSkipPatternProviderConfig.getPathPrefix(contextPath, webEndpointProperties.getBasePath()) + "/(", ")"));
            if (StringUtils.hasText((String)pattern)) {
                return Optional.of(Pattern.compile(pattern));
            }
            return Optional.empty();
        }

        private static String getPathPrefix(String contextPath, String actuatorBasePath) {
            String result = "";
            if (StringUtils.hasText((String)contextPath)) {
                result = result + contextPath;
            }
            if (!actuatorBasePath.equals("/")) {
                result = result + actuatorBasePath;
            }
            return result;
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        public SkipPattern skipPatternForActuatorEndpointsSamePort(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(serverProperties.getServlet().getContextPath(), webEndpointProperties, endpointsSupplier);
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnProperty(name={"management.server.servlet.context-path"}, havingValue="/", matchIfMissing=true)
        public SkipPattern skipPatternForActuatorEndpointsDifferentPort(WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(null, webEndpointProperties, endpointsSupplier);
        }
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnProperty(value={"opentracing.spring.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ManagementSkipPatternProviderConfig {
        protected ManagementSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            String contextPath = managementServerProperties.getServlet().getContextPath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(contextPath + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SkipPattern skipPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            return () -> ManagementSkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties);
        }
    }
}

