/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.starter;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.client.TracingWebClientBeanPostProcessor;
import io.opentracing.contrib.spring.web.client.WebClientSpanDecorator;
import io.opentracing.contrib.spring.web.starter.WebClientTracingProperties;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnProperty(prefix="opentracing.spring.web.client", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@EnableConfigurationProperties(value={WebClientTracingProperties.class})
public class WebClientTracingAutoConfiguration {
    @Bean
    public static TracingWebClientBeanPostProcessor tracingWebClientBeanPostProcessor(Tracer tracer, ObjectProvider<List<WebClientSpanDecorator>> webClientSpanDecorators) {
        return new TracingWebClientBeanPostProcessor(tracer, (List)webClientSpanDecorators.getObject());
    }

    @ConditionalOnMissingBean(value={WebClientSpanDecorator.class})
    @Configuration
    static class DefaultWebClientSpanDecorators {
        DefaultWebClientSpanDecorators() {
        }

        @Bean
        WebClientSpanDecorator standardTagsWebClientSpanDecorator() {
            return new WebClientSpanDecorator.StandardTags();
        }
    }
}

