/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class TracingAsyncRestTemplateInterceptor
implements AsyncClientHttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(TracingAsyncRestTemplateInterceptor.class);
    private Tracer tracer;
    private List<RestTemplateSpanDecorator> spanDecorators;

    public TracingAsyncRestTemplateInterceptor() {
        this(GlobalTracer.get());
    }

    public TracingAsyncRestTemplateInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.spanDecorators = Collections.singletonList(new RestTemplateSpanDecorator.StandardTags());
    }

    public TracingAsyncRestTemplateInterceptor(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<RestTemplateSpanDecorator>(spanDecorators);
    }

    public ListenableFuture<ClientHttpResponse> intercept(final HttpRequest httpRequest, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        final Scope scope = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(false);
        this.tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
        for (RestTemplateSpanDecorator spanDecorator : this.spanDecorators) {
            try {
                spanDecorator.onRequest(httpRequest, scope.span());
            }
            catch (RuntimeException exDecorator) {
                log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
            }
        }
        ListenableFuture future = execution.executeAsync(httpRequest, body);
        final Span span = scope.span();
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<ClientHttpResponse>(){

            public void onSuccess(ClientHttpResponse httpResponse) {
                try (Scope asyncScope = TracingAsyncRestTemplateInterceptor.this.tracer.scopeManager().activate(span, true);){
                    for (RestTemplateSpanDecorator spanDecorator : TracingAsyncRestTemplateInterceptor.this.spanDecorators) {
                        try {
                            spanDecorator.onResponse(httpRequest, httpResponse, scope.span());
                        }
                        catch (RuntimeException exDecorator) {
                            log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                        }
                    }
                }
            }

            public void onFailure(Throwable ex) {
                try (Scope asyncScope = TracingAsyncRestTemplateInterceptor.this.tracer.scopeManager().activate(span, true);){
                    for (RestTemplateSpanDecorator spanDecorator : TracingAsyncRestTemplateInterceptor.this.spanDecorators) {
                        try {
                            spanDecorator.onError(httpRequest, ex, scope.span());
                        }
                        catch (RuntimeException exDecorator) {
                            log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                        }
                    }
                }
            }
        });
        scope.close();
        return future;
    }
}

