/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TracingRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Log log = LogFactory.getLog(TracingRestTemplateInterceptor.class);
    private Tracer tracer;
    private List<RestTemplateSpanDecorator> spanDecorators;

    public TracingRestTemplateInterceptor() {
        this(GlobalTracer.get(), Collections.singletonList(new RestTemplateSpanDecorator.StandardTags()));
    }

    public TracingRestTemplateInterceptor(Tracer tracer) {
        this(tracer, Collections.singletonList(new RestTemplateSpanDecorator.StandardTags()));
    }

    public TracingRestTemplateInterceptor(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<RestTemplateSpanDecorator>(spanDecorators);
    }

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse httpResponse;
        try (Scope scope = this.tracer.buildSpan(httpRequest.getMethod().toString()).withTag(Tags.SPAN_KIND.getKey(), "client").startActive(true);){
            this.tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(httpRequest.getHeaders()));
            for (RestTemplateSpanDecorator restTemplateSpanDecorator : this.spanDecorators) {
                try {
                    restTemplateSpanDecorator.onRequest(httpRequest, scope.span());
                }
                catch (RuntimeException exDecorator) {
                    log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                }
            }
            try {
                httpResponse = execution.execute(httpRequest, body);
            }
            catch (Exception ex) {
                for (RestTemplateSpanDecorator spanDecorator : this.spanDecorators) {
                    try {
                        spanDecorator.onError(httpRequest, ex, scope.span());
                    }
                    catch (RuntimeException exDecorator) {
                        log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                    }
                }
                throw ex;
            }
            for (RestTemplateSpanDecorator restTemplateSpanDecorator : this.spanDecorators) {
                try {
                    restTemplateSpanDecorator.onResponse(httpRequest, httpResponse, scope.span());
                }
                catch (RuntimeException exDecorator) {
                    log.error((Object)"Exception during decorating span", (Throwable)exDecorator);
                }
            }
        }
        return httpResponse;
    }
}

