/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.TracingClientResponseMono;
import io.opentracing.contrib.spring.web.client.WebClientSpanDecorator;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class TracingExchangeFilterFunction
implements ExchangeFilterFunction {
    private final Tracer tracer;
    private final List<WebClientSpanDecorator> spanDecorators;

    public TracingExchangeFilterFunction(Tracer tracer, List<WebClientSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = spanDecorators;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        return new TracingClientResponseMono(clientRequest, next, this.tracer, this.spanDecorators);
    }
}

