/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.webfilter;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.webfilter.HttpHeadersExtractAdapter;
import io.opentracing.contrib.spring.web.webfilter.TracingSubscriber;
import io.opentracing.contrib.spring.web.webfilter.TracingWebFilter;
import io.opentracing.contrib.spring.web.webfilter.WebFluxSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.List;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.context.Context;

class TracingOperator
extends MonoOperator<Void, Void> {
    private final Tracer tracer;
    private final ServerWebExchange exchange;
    private final List<WebFluxSpanDecorator> spanDecorators;

    TracingOperator(Mono<? extends Void> source, ServerWebExchange exchange, Tracer tracer, List<WebFluxSpanDecorator> spanDecorators) {
        super(source);
        this.tracer = tracer;
        this.exchange = exchange;
        this.spanDecorators = spanDecorators;
    }

    public void subscribe(CoreSubscriber<? super Void> subscriber) {
        Context context = subscriber.currentContext();
        Span parentSpan = context.getOrEmpty(Span.class).orElseGet(() -> ((Tracer)this.tracer).activeSpan());
        ServerHttpRequest request = this.exchange.getRequest();
        SpanContext extractedContext = parentSpan != null ? parentSpan.context() : this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersExtractAdapter(request.getHeaders()));
        Span span = this.tracer.buildSpan(request.getMethodValue()).asChildOf(extractedContext).withTag(Tags.SPAN_KIND.getKey(), "server").start();
        try (Scope scope = this.tracer.scopeManager().activate(span, false);){
            this.exchange.getAttributes().put(TracingWebFilter.SERVER_SPAN_CONTEXT, span.context());
            this.source.subscribe((CoreSubscriber)new TracingSubscriber(subscriber, this.exchange, context, span, this.spanDecorators));
        }
    }
}

