/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Span;
import io.opentracing.contrib.spring.web.client.WebClientSpanDecorator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

class TracingClientResponseSubscriber
implements CoreSubscriber<ClientResponse> {
    private static final Log LOG = LogFactory.getLog(TracingClientResponseSubscriber.class);
    private final CoreSubscriber<? super ClientResponse> subscriber;
    private final ClientRequest clientRequest;
    private final Context context;
    private final Span span;
    private final List<WebClientSpanDecorator> spanDecorators;

    TracingClientResponseSubscriber(CoreSubscriber<? super ClientResponse> subscriber, ClientRequest clientRequest, Context context, Span span, List<WebClientSpanDecorator> spanDecorators) {
        this.subscriber = subscriber;
        this.clientRequest = clientRequest;
        this.context = context.put(Span.class, (Object)span);
        this.span = span;
        this.spanDecorators = spanDecorators;
    }

    public void onSubscribe(final Subscription subscription) {
        this.spanDecorators.forEach(spanDecorator -> this.safelyCall(() -> spanDecorator.onRequest(this.clientRequest, this.span)));
        this.subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                subscription.request(n);
            }

            public void cancel() {
                TracingClientResponseSubscriber.this.spanDecorators.forEach(spanDecorator -> TracingClientResponseSubscriber.this.safelyCall(() -> spanDecorator.onCancel(TracingClientResponseSubscriber.this.clientRequest, TracingClientResponseSubscriber.this.span)));
                subscription.cancel();
                TracingClientResponseSubscriber.this.span.finish();
            }
        });
    }

    public void onNext(ClientResponse clientResponse) {
        try {
            this.subscriber.onNext((Object)ClientResponse.from((ClientResponse)clientResponse).body(clientResponse.bodyToFlux(DataBuffer.class).subscriberContext(this.context)).build());
        }
        finally {
            this.spanDecorators.forEach(spanDecorator -> this.safelyCall(() -> spanDecorator.onResponse(this.clientRequest, clientResponse, this.span)));
        }
    }

    public void onError(Throwable throwable) {
        try {
            this.subscriber.onError(throwable);
        }
        finally {
            this.spanDecorators.forEach(spanDecorator -> this.safelyCall(() -> spanDecorator.onError(this.clientRequest, throwable, this.span)));
            this.span.finish();
        }
    }

    public void onComplete() {
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.span.finish();
        }
    }

    public Context currentContext() {
        return this.context;
    }

    private void safelyCall(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Exception during decorating span", (Throwable)e);
        }
    }
}

