/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public interface WebClientSpanDecorator {
    public void onRequest(ClientRequest var1, Span var2);

    public void onResponse(ClientRequest var1, ClientResponse var2, Span var3);

    public void onError(ClientRequest var1, Throwable var2, Span var3);

    public void onCancel(ClientRequest var1, Span var2);

    public static class StandardTags
    implements WebClientSpanDecorator {
        static final String COMPONENT_NAME = "java-spring-webclient";

        @Override
        public void onRequest(ClientRequest clientRequest, Span span) {
            Tags.COMPONENT.set(span, COMPONENT_NAME);
            Tags.HTTP_URL.set(span, clientRequest.url().toString());
            Tags.HTTP_METHOD.set(span, clientRequest.method().toString());
            if (clientRequest.url().getPort() != -1) {
                Tags.PEER_PORT.set(span, Integer.valueOf(clientRequest.url().getPort()));
            }
        }

        @Override
        public void onResponse(ClientRequest clientRequest, ClientResponse clientResponse, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(clientResponse.rawStatusCode()));
        }

        @Override
        public void onError(ClientRequest clientRequest, Throwable throwable, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(StandardTags.errorLogs(throwable));
        }

        @Override
        public void onCancel(ClientRequest httpRequest, Span span) {
            HashMap<String, String> logs = new HashMap<String, String>(2);
            logs.put("event", "cancelled");
            logs.put("message", "The subscription was cancelled");
            span.log(logs);
        }

        static Map<String, Object> errorLogs(Throwable throwable) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", throwable);
            return errorLogs;
        }
    }
}

