/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.webfilter;

import io.opentracing.propagation.TextMap;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;

class HttpHeadersExtractAdapter
implements TextMap {
    private static final Stream<String> STREAM_OF_NULL = Stream.of(new String[]{null});
    private final HttpHeaders httpHeaders;

    HttpHeadersExtractAdapter(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.httpHeaders.entrySet().stream().flatMap(entry -> HttpHeadersExtractAdapter.getValuesStream((List)entry.getValue()).map(value -> HttpHeadersExtractAdapter.newEntry((String)entry.getKey(), value))).iterator();
    }

    private static Stream<String> getValuesStream(List<String> values) {
        return values.isEmpty() ? STREAM_OF_NULL : values.stream();
    }

    private static Map.Entry<String, String> newEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("This class should be used only with Tracer.inject()!");
    }
}

