/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.webfilter;

import io.opentracing.Span;
import io.opentracing.contrib.spring.web.webfilter.TracingWebFilter;
import io.opentracing.contrib.spring.web.webfilter.WebFluxSpanDecorator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

class TracingSubscriber
implements CoreSubscriber<Void> {
    private static final Log LOG = LogFactory.getLog(TracingSubscriber.class);
    private final CoreSubscriber<? super Void> subscriber;
    private final ServerWebExchange exchange;
    private final Context context;
    private final Span span;
    private final List<WebFluxSpanDecorator> spanDecorators;

    TracingSubscriber(CoreSubscriber<? super Void> subscriber, ServerWebExchange exchange, Context context, Span span, List<WebFluxSpanDecorator> spanDecorators) {
        this.subscriber = subscriber;
        this.exchange = exchange;
        this.context = context.put(Span.class, (Object)span);
        this.span = span;
        this.spanDecorators = spanDecorators;
    }

    public void onSubscribe(final Subscription subscription) {
        this.subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                TracingSubscriber.this.spanDecorators.forEach(spanDecorator -> TracingSubscriber.this.safelyCall(() -> spanDecorator.onRequest(TracingSubscriber.this.exchange, TracingSubscriber.this.span)));
                subscription.request(n);
            }

            public void cancel() {
                TracingSubscriber.this.span.finish();
                TracingSubscriber.this.exchange.getAttributes().remove(TracingWebFilter.SERVER_SPAN_CONTEXT);
                subscription.cancel();
            }
        });
    }

    public void onNext(Void aVoid) {
        this.subscriber.onNext((Object)aVoid);
    }

    public void onError(Throwable throwable) {
        this.spanDecorators.forEach(spanDecorator -> this.safelyCall(() -> spanDecorator.onError(this.exchange, throwable, this.span)));
        this.span.finish();
        this.exchange.getAttributes().remove(TracingWebFilter.SERVER_SPAN_CONTEXT);
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.spanDecorators.forEach(spanDecorator -> this.safelyCall(() -> spanDecorator.onResponse(this.exchange, this.span)));
        this.span.finish();
        this.exchange.getAttributes().remove(TracingWebFilter.SERVER_SPAN_CONTEXT);
        this.subscriber.onComplete();
    }

    public Context currentContext() {
        return this.context;
    }

    private void safelyCall(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Exception during decorating span", (Throwable)e);
        }
    }
}

