/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.tracerresolver;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.PriorityComparator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TracerResolver {
    private static final Logger LOGGER = Logger.getLogger(TracerResolver.class.getName());
    private static final ServiceLoader<TracerResolver> RESOLVERS = ServiceLoader.load(TracerResolver.class);
    private static final ServiceLoader<Tracer> FALLBACK = ServiceLoader.load(Tracer.class);

    protected abstract Tracer resolve();

    public static Tracer resolveTracer() {
        for (TracerResolver resolver : PriorityComparator.prioritize(RESOLVERS)) {
            try {
                Tracer tracer = resolver.resolve();
                if (tracer == null) continue;
                LOGGER.log(Level.FINER, "Resolved tracer: {0}.", tracer);
                return tracer;
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error resolving tracer using " + resolver + ": " + rte.getMessage(), rte);
            }
        }
        for (Tracer tracer : PriorityComparator.prioritize(FALLBACK)) {
            if (tracer == null) continue;
            LOGGER.log(Level.FINER, "Resolved tracer: {0}.", tracer);
            return tracer;
        }
        LOGGER.log(Level.FINEST, "No tracer was resolved.");
        return null;
    }

    public static void reload() {
        RESOLVERS.reload();
        FALLBACK.reload();
        LOGGER.log(Level.FINER, "Resolvers were reloaded.");
    }
}

