/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.propagation;

import io.opentracing.propagation.Binary;
import io.opentracing.propagation.BinaryAdapter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class Adapters {
    private Adapters() {
    }

    public static Binary injectBinary(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        return new BinaryAdapter(Channels.newChannel(stream));
    }

    public static Binary injectBinary(WritableByteChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel cannot be null");
        }
        return new BinaryAdapter(channel);
    }

    public static Binary extractBinary(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        return new BinaryAdapter(Channels.newChannel(stream));
    }

    public static Binary extractBinary(ReadableByteChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel cannot be null");
        }
        return new BinaryAdapter(channel);
    }
}

