/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.propagation;

import io.opentracing.propagation.Binary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class BinaryAdapter
implements Binary {
    private final ReadableByteChannel readChannel;
    private final WritableByteChannel writeChannel;

    BinaryAdapter(WritableByteChannel writeChannel) {
        this.writeChannel = writeChannel;
        this.readChannel = null;
    }

    BinaryAdapter(ReadableByteChannel readChannel) {
        this.readChannel = readChannel;
        this.writeChannel = null;
    }

    ReadableByteChannel readChannel() {
        return this.readChannel;
    }

    WritableByteChannel writeChannel() {
        return this.writeChannel;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (this.writeChannel == null) {
            throw new UnsupportedOperationException();
        }
        return this.writeChannel.write(buffer);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        if (this.readChannel == null) {
            throw new UnsupportedOperationException();
        }
        return this.readChannel.read(buffer);
    }
}

