/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.propagation;

import io.opentracing.propagation.Binary;
import java.nio.ByteBuffer;

public final class BinaryAdapters {
    private BinaryAdapters() {
    }

    public static Binary extractionCarrier(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        return new BinaryExtractAdapter(buffer);
    }

    public static Binary injectionCarrier(ByteBuffer buffer) {
        return new BinaryInjectAdapter(buffer);
    }

    static class BinaryInjectAdapter
    implements Binary {
        ByteBuffer buffer;

        public BinaryInjectAdapter(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer injectionBuffer(int length) {
            if (length < 1) {
                throw new IllegalArgumentException("length needs to be larger than 0");
            }
            if (length > this.buffer.remaining()) {
                throw new AssertionError((Object)"length is larger than the backing ByteBuffer remaining length");
            }
            this.buffer.limit(this.buffer.position() + length);
            return this.buffer;
        }

        @Override
        public ByteBuffer extractionBuffer() {
            throw new UnsupportedOperationException();
        }
    }

    static class BinaryExtractAdapter
    implements Binary {
        ByteBuffer buffer;

        public BinaryExtractAdapter(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer injectionBuffer(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer extractionBuffer() {
            return this.buffer;
        }
    }
}

