/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.NoopSpan;
import io.opentracing.NoopSpanContext;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.impl.AbstractSpan;
import io.opentracing.impl.NoopSpanBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class AbstractSpanBuilder
implements Tracer.SpanBuilder {
    protected String operationName = null;
    protected final List<Reference> references = new ArrayList<Reference>();
    protected Instant start = Instant.now();
    private final Map<String, String> stringTags = new HashMap<String, String>();
    private final Map<String, Boolean> booleanTags = new HashMap<String, Boolean>();
    private final Map<String, Number> numberTags = new HashMap<String, Number>();
    private final Map<String, String> baggage = new HashMap<String, String>();

    AbstractSpanBuilder(String operationName) {
        this.operationName = operationName;
    }

    protected abstract AbstractSpan createSpan();

    abstract AbstractSpanBuilder withStateItem(String var1, Object var2);

    abstract boolean isTraceState(String var1, Object var2);

    public final AbstractSpanBuilder addReference(String referenceType, SpanContext referredTo) {
        this.references.add(new Reference(referenceType, referredTo));
        return this;
    }

    public final AbstractSpanBuilder asChildOf(SpanContext parent) {
        if (NoopSpanContext.class.isAssignableFrom(parent.getClass())) {
            return NoopSpanBuilder.INSTANCE;
        }
        this.withBaggageFrom(parent);
        return this.addReference("child_of", parent);
    }

    public final AbstractSpanBuilder asChildOf(Span parent) {
        if (NoopSpan.class.isAssignableFrom(parent.getClass())) {
            return NoopSpanBuilder.INSTANCE;
        }
        this.withBaggageFrom(parent.context());
        return this.addReference("child_of", parent.context());
    }

    public final AbstractSpanBuilder withTag(String key, String value) {
        this.stringTags.put(key, value);
        return this;
    }

    public final AbstractSpanBuilder withTag(String key, boolean value) {
        this.booleanTags.put(key, value);
        return this;
    }

    public final AbstractSpanBuilder withTag(String key, Number value) {
        this.numberTags.put(key, value);
        return this;
    }

    public final AbstractSpanBuilder withStartTimestamp(long microseconds) {
        long epochSeconds = TimeUnit.MICROSECONDS.toSeconds(microseconds);
        long nanos = TimeUnit.MICROSECONDS.toNanos(microseconds) - TimeUnit.SECONDS.toNanos(epochSeconds);
        this.start = Instant.ofEpochSecond(epochSeconds, nanos);
        return this;
    }

    public final AbstractSpanBuilder withBaggageItem(String key, String value) {
        assert (!this.isTraceState(key, value));
        this.baggage.put(key, value);
        return this;
    }

    public final Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public final Span start() {
        AbstractSpan span = this.createSpan();
        this.stringTags.entrySet().forEach(entry -> span.setTag((String)entry.getKey(), (String)entry.getValue()));
        this.booleanTags.entrySet().forEach(entry -> span.setTag((String)entry.getKey(), (Boolean)entry.getValue()));
        this.numberTags.entrySet().forEach(entry -> span.setTag((String)entry.getKey(), (Number)entry.getValue()));
        this.baggage.entrySet().forEach(entry -> span.setBaggageItem((String)entry.getKey(), (String)entry.getValue()));
        return span;
    }

    private void withBaggageFrom(SpanContext from) {
        for (Map.Entry baggageItem : from.baggageItems()) {
            this.withBaggageItem((String)baggageItem.getKey(), (String)baggageItem.getValue());
        }
    }

    public static final class Reference {
        private final String referenceType;
        private final SpanContext referredTo;

        Reference(String type, SpanContext referredTo) {
            this.referenceType = type;
            this.referredTo = referredTo;
        }

        public final Object getReferenceType() {
            return this.referenceType;
        }

        public final SpanContext getReferredTo() {
            return this.referredTo;
        }
    }
}

