/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.model.ASTWalkingContext;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.common.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.List;

public abstract class ASTItem {
    protected String _preprocessedSource;
    protected String _originalSource;
    private String _untrimmedSource;
    private int position;

    public String getPreprocessedSource() {
        return this._preprocessedSource;
    }

    public boolean hasSource() {
        return !StringUtils.isNullOrEmpty(this.getPreprocessedSource());
    }

    public void setSource(String original) {
        if (original != null) {
            this._untrimmedSource = original;
            this._preprocessedSource = original.trim();
            this._originalSource = StringUtils.reverseKeywords(this._preprocessedSource);
        }
    }

    public String getUntrimmedSource() {
        return this._untrimmedSource;
    }

    public String getOriginalSource() {
        return this._originalSource;
    }

    public String getType() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public String getTypecommon() {
        return "../common/" + this.getType();
    }

    public String print(int level) {
        return this.space(level) + this.getType() + "\n";
    }

    public String space(int level) {
        return StringUtils.padLeft(" ", level * 4);
    }

    public String getGlobalPlain() {
        return this._preprocessedSource;
    }

    @JsonIgnore
    public List<ASTCondition> getAllConditions() {
        return new ArrayList<ASTCondition>();
    }

    public void walk(ThrowingConsumer<ASTWalkingContext> action) {
        this.walk(action, null);
    }

    public void walk(ThrowingConsumer<ASTWalkingContext> action, Class<?> cls) {
        if (action != null && this.children() != null && this.children().size() > 0) {
            this.walk(this.children(), action, cls);
        }
    }

    public void walk(List<ASTItem> children, ThrowingConsumer<ASTWalkingContext> action, Class<?> cls) {
        if (action != null && children != null && children.size() > 0) {
            children.forEach(c -> {
                if (c != null) {
                    if (cls == null || cls.isInstance(c)) {
                        action.accept(new ASTWalkingContext(this, (ASTItem)c));
                    }
                    c.walk(action, cls);
                }
            });
        }
    }

    public List<ASTItem> children() {
        return new ArrayList<ASTItem>();
    }

    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        if (cls.isInstance(this)) {
            items.add(this);
        }
        return items;
    }

    @JsonIgnore
    public List<ASTOperandProperty> getProperties() {
        return new ArrayList<ASTOperandProperty>();
    }

    public int getGlobalPosition() {
        return this.position;
    }

    public void setGlobalPosition(int position) {
        this.position = position;
    }
}

