/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast;

import io.openvalidation.common.ast.ASTComment;
import io.openvalidation.common.ast.ASTGlobalElement;
import io.openvalidation.common.ast.ASTGlobalNamedElement;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.ASTUnknown;
import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.utils.LINQ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ASTModel
extends ASTItem {
    private Map<String, Object> _params = new HashMap<String, Object>();
    private List<ASTGlobalElement> _elements = new ArrayList<ASTGlobalElement>();
    private List<ASTRule> _nullCheckRules = null;
    private List<String> _semanticOperatorNames = new ArrayList<String>();

    public List<ASTGlobalElement> getElements() {
        return this._elements;
    }

    public boolean hasElements() {
        return this.getElements() == null || this.getElements().size() < 1;
    }

    public boolean hasValidElements() {
        return this.getValidElements().size() > 0;
    }

    public List<ASTGlobalElement> getValidElements() {
        return this._elements.stream().filter(s -> !(s instanceof ASTUnknown)).collect(Collectors.toList());
    }

    public List<ASTUnknown> getUnknownElements() {
        return this._elements.stream().filter(s -> s instanceof ASTUnknown).map(s -> (ASTUnknown)s).collect(Collectors.toList());
    }

    public void add(ASTGlobalElement element) {
        this._elements.add(element);
    }

    public List<ASTComment> getComments() {
        return this._elements.stream().filter(s -> s instanceof ASTComment).map(s -> (ASTComment)s).collect(Collectors.toList());
    }

    public List<ASTGlobalNamedElement> getNamedElements() {
        return this._elements.stream().filter(s -> s instanceof ASTGlobalNamedElement).map(s -> (ASTGlobalNamedElement)s).collect(Collectors.toList());
    }

    public List<ASTVariable> getVariables() {
        return this._elements.stream().filter(s -> s instanceof ASTVariable).map(s -> (ASTVariable)s).collect(Collectors.toList());
    }

    public List<ASTRule> getRules() {
        return this._elements.stream().filter(s -> s instanceof ASTRule).map(s -> (ASTRule)s).collect(Collectors.toList());
    }

    public List<ASTRule> getNullCheckRules() {
        return this._nullCheckRules;
    }

    public void setNullCheckRules(List<ASTRule> rules) {
        this._nullCheckRules = rules;
    }

    public List<ASTGlobalElement> getRulesAndComments() {
        return this._elements.stream().filter(s -> s instanceof ASTRule || s instanceof ASTComment).collect(Collectors.toList());
    }

    public ASTComment addComment(String cmt) {
        ASTComment comment = new ASTComment(cmt);
        this._elements.add(comment);
        return comment;
    }

    public Map<String, Object> getParams() {
        return this._params;
    }

    public ASTModel addParam(String name, Object value) {
        this._params.put(name, value);
        return this;
    }

    public ASTModel addParams(Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            this._params.putAll(params);
        }
        return this;
    }

    public ASTModel setDefault(String name, String value) {
        if (!this._params.containsKey(name)) {
            this.addParam(name, value);
        }
        return this;
    }

    @Override
    public List<ASTItem> children() {
        return LINQ.ofType(this._elements, ASTItem.class);
    }

    @Override
    public List<ASTCondition> getAllConditions() {
        return this._elements.stream().map(e -> e.getAllConditions()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        ArrayList lst = new ArrayList();
        lst.addAll(this._elements.stream().map(e -> e.collectItemsOfType(cls)).flatMap(Collection::stream).collect(Collectors.toList()));
        return lst;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTModel)) {
            return false;
        }
        ASTModel astModel = (ASTModel)o;
        return Objects.equals(this._elements, astModel._elements);
    }

    public int hashCode() {
        return Objects.hash(this._elements);
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("ROOT\n");
        for (ASTItem aSTItem : this._elements) {
            sb.append(aSTItem.print(1));
        }
        return sb.toString();
    }

    public List<String> getSemanticOperatorNames() {
        return this._semanticOperatorNames;
    }

    public void addSemanticOperatorName(String ... names) {
        if (names != null) {
            for (String n : names) {
                this._semanticOperatorNames.add(n);
            }
        }
    }
}

