/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast;

import io.openvalidation.common.ast.ASTActionBase;
import io.openvalidation.common.ast.ASTGlobalNamedElement;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import java.util.ArrayList;
import java.util.List;

public class ASTRule
extends ASTGlobalNamedElement {
    private List<ASTConditionBase> _invalidConditions = new ArrayList<ASTConditionBase>();
    private ASTConditionBase condition;
    private ASTActionBase action;

    public ASTConditionBase getCondition() {
        return this.condition;
    }

    public void setCondition(ASTConditionBase con) {
        this.condition = con;
    }

    public ASTActionBase getAction() {
        return this.action;
    }

    public void setAction(ASTActionBase action) {
        this.action = action;
    }

    public List<ASTOperandProperty> getRelatedProperties() {
        return this.condition.getProperties();
    }

    public List<ASTOperandProperty> getAllParentProperties() {
        ArrayList<ASTOperandProperty> properties = new ArrayList<ASTOperandProperty>();
        if (this.getCondition() != null) {
            properties.addAll(this.getCondition().getAllParentProperties());
        }
        return properties;
    }

    public void addInvalidCondition(ASTConditionBase condition) {
        this._invalidConditions.add(condition);
    }

    public List<ASTConditionBase> getInvalidConditions() {
        return this._invalidConditions;
    }

    public boolean isConstrainedRule() {
        if (this.condition instanceof ASTCondition) {
            return ((ASTCondition)this.condition).isConstrainedCondition();
        }
        if (this.condition instanceof ASTConditionGroup) {
            return ((ASTConditionGroup)this.condition).hasConstrainedCondition();
        }
        return false;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.add(this.getCondition());
        items.addAll(this.getInvalidConditions());
        items.add(this.getAction());
        return items;
    }

    @Override
    public List<ASTCondition> getAllConditions() {
        if (this.getCondition() == null) {
            return super.getAllConditions();
        }
        return this.getCondition().getAllConditions();
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType());
        if (this.action != null) {
            sb.append(this.action.print(level + 1));
        }
        sb.append("\n");
        if (this.condition != null) {
            sb.append(this.condition.print(level + 1));
        }
        return sb.toString();
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.condition != null) {
            lst.addAll(this.condition.collectItemsOfType(cls));
        }
        if (this.action != null) {
            lst.addAll(this.action.collectItemsOfType(cls));
        }
        return lst;
    }
}

