/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast;

import io.openvalidation.common.ast.ASTGlobalNamedElement;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.NameMasking;
import java.util.ArrayList;
import java.util.List;

public class ASTVariable
extends ASTGlobalNamedElement {
    private ASTOperandBase value;
    private String codeSafeName;

    public ASTOperandBase getValue() {
        return this.value;
    }

    public void setValue(ASTOperandBase value) {
        this.value = value;
    }

    public DataPropertyType getDataType() {
        return this.value != null ? this.value.getDataType() : null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setCodeSafeName(name);
    }

    private void setCodeSafeName(String name) {
        this.codeSafeName = NameMasking.maskName(name);
    }

    public String getCodeSafeName() {
        return this.codeSafeName;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.add(this.getValue());
        return items;
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.getValue() != null) {
            lst.addAll(this.getValue().collectItemsOfType(cls));
        }
        return lst;
    }

    @Override
    public List<ASTCondition> getAllConditions() {
        return this.value.getAllConditions();
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level)).append(super.print(level).trim()).append(" : ").append(this.getName()).append("\n");
        if (this.value != null) {
            sb.append(this.value.print(level + 1));
        }
        return sb.toString();
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        return this.getValue().getProperties();
    }
}

