/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.builder;

import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.builder.ASTBuilderBase;
import io.openvalidation.common.ast.builder.ASTConditionGroupBuilder;
import io.openvalidation.common.ast.builder.ASTOperandArithmeticalBuilder;
import io.openvalidation.common.ast.builder.ASTOperandArrayBuilder;
import io.openvalidation.common.ast.builder.ASTOperandFunctionBuilder;
import io.openvalidation.common.ast.builder.ASTPropertyBuilder;
import io.openvalidation.common.ast.builder.ASTRuleBuilder;
import io.openvalidation.common.ast.builder.ASTVariableBuilder;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStatic;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.StringUtils;
import java.util.List;

public class ASTConditionBuilder
extends ASTBuilderBase<ASTConditionBuilder, ASTRuleBuilder, ASTCondition> {
    private ASTConditionGroupBuilder parentGroup;
    private ASTPropertyBuilder parentProperty;
    private ASTVariableBuilder parentVariableBuilder;

    public ASTConditionBuilder() {
        super(null, ASTCondition.class);
    }

    public ASTConditionBuilder(ASTRuleBuilder prntBldr) {
        super(prntBldr, ASTCondition.class);
    }

    public ASTConditionBuilder(ASTPropertyBuilder parent) {
        super(null, ASTCondition.class);
        this.parentProperty = parent;
    }

    public ASTConditionBuilder(ASTConditionGroupBuilder conditionGroup) {
        super(null, ASTCondition.class);
        this.parentGroup = conditionGroup;
    }

    public ASTConditionBuilder(ASTVariableBuilder prntBldr) {
        super(null, ASTCondition.class);
        this.parentVariableBuilder = prntBldr;
    }

    public ASTPropertyBuilder parentProperty() {
        return this.parentProperty;
    }

    public ASTVariableBuilder parentVariable() {
        return this.parentVariableBuilder;
    }

    public ASTConditionBuilder withConnector(ASTConditionConnector connector) {
        ((ASTCondition)this.model).setConnector(connector);
        return this;
    }

    public ASTConditionBuilder withOperator(ASTComparisonOperator operator) {
        ((ASTCondition)this.model).setOperator(operator);
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsProperty(String ... property) {
        ((ASTCondition)this.model).setLeftOperand(new ASTOperandProperty(property));
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsPropertyWithLambdayToken(String property, String lambdaToken) {
        String[] stringArray;
        if (property.isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = property;
        }
        String[] prop = stringArray;
        return this.withLeftOperandAsPropertyWithLambdayToken(prop, lambdaToken);
    }

    public ASTConditionBuilder withLeftOperandAsPropertyWithLambdayToken(String[] property, String lambdaToken) {
        ASTOperandProperty prop = new ASTOperandProperty(property);
        if (!StringUtils.isNullOrEmpty(lambdaToken)) {
            prop.setLambdaToken(lambdaToken);
        }
        ((ASTCondition)this.model).setLeftOperand(prop);
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsString(String value) {
        ((ASTCondition)this.model).setLeftOperand(new ASTOperandStaticString(value));
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsNumber(double number) {
        ((ASTCondition)this.model).setLeftOperand(new ASTOperandStaticNumber(number));
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsVariable(String variable) {
        ((ASTCondition)this.model).setLeftOperand(new ASTOperandVariable(variable));
        return this;
    }

    public ASTConditionBuilder withLeftOperand(ASTOperandBase operand) {
        ((ASTCondition)this.model).setLeftOperand(operand);
        return this;
    }

    public ASTConditionBuilder withLeftOperandAsBoolean(boolean value) {
        ((ASTCondition)this.model).setLeftOperand(new ASTOperandStatic(("" + value).toLowerCase()));
        return this;
    }

    public ASTConditionBuilder markAsConstrainedCondition() {
        ((ASTCondition)this.model).setConstrainedCondition(true);
        return this;
    }

    public ASTConditionBuilder markAsHasToBeInverted() {
        ((ASTCondition)this.model).setHasToBeInverted(true);
        return this;
    }

    public ASTConditionBuilder unmarkAsConstrainedCondition() {
        ((ASTCondition)this.model).setConstrainedCondition(false);
        return this;
    }

    public ASTOperandArrayBuilder withLeftOperandAsArray() {
        ASTOperandArrayBuilder arrayBuilder = new ASTOperandArrayBuilder(this);
        arrayBuilder.create();
        ((ASTCondition)this.model).setLeftOperand((ASTOperandBase)arrayBuilder.getModel());
        return arrayBuilder;
    }

    public ASTOperandArrayBuilder withLeftOperandAsArray(float ... numbers) {
        ASTOperandArrayBuilder arrayBuilder = this.withLeftOperandAsArray();
        if (numbers != null && numbers.length > 0) {
            for (float num : numbers) {
                arrayBuilder.addItem(new ASTOperandStaticNumber(num));
            }
        }
        return arrayBuilder;
    }

    public ASTOperandArithmeticalBuilder createLeftOperandAsArithmeticalOperation() {
        ASTOperandArithmeticalBuilder arithmeticalBuilder = new ASTOperandArithmeticalBuilder(this);
        arithmeticalBuilder.create();
        ((ASTCondition)this.model).setLeftOperand((ASTOperandBase)arithmeticalBuilder.getModel());
        return arithmeticalBuilder;
    }

    public ASTOperandFunctionBuilder createLeftOperandAsFunction() {
        ASTOperandFunctionBuilder functionBuilder = new ASTOperandFunctionBuilder(this);
        functionBuilder.create();
        ((ASTCondition)this.model).setLeftOperand((ASTOperandBase)functionBuilder.getModel());
        return functionBuilder;
    }

    public ASTOperandFunctionBuilder createLeftOperandAsFunction(String name) {
        ASTOperandFunctionBuilder functionBuilder = this.createLeftOperandAsFunction();
        functionBuilder.withName(name);
        return functionBuilder;
    }

    public ASTConditionBuilder withRightOperandAsProperty(String ... property) {
        ((ASTCondition)this.model).setRightOperand(new ASTOperandProperty(property));
        return this;
    }

    public ASTConditionBuilder withRightOperandAsNumber(double number) {
        ((ASTCondition)this.model).setRightOperand(new ASTOperandStaticNumber(number));
        return this;
    }

    public ASTConditionBuilder withRightOperandAsString(String value) {
        ((ASTCondition)this.model).setRightOperand(new ASTOperandStaticString(value));
        return this;
    }

    public ASTConditionBuilder withRightOperandAsVariable(String variable) {
        ((ASTCondition)this.model).setRightOperand(new ASTOperandVariable(variable));
        return this;
    }

    public ASTConditionBuilder withRightOperand(ASTOperandBase operand) {
        ((ASTCondition)this.model).setRightOperand(operand);
        return this;
    }

    public ASTConditionBuilder withRightOperandAsBoolean(boolean value) {
        ASTOperandStatic staticBool = new ASTOperandStatic(("" + value).toLowerCase());
        staticBool.setDataType(DataPropertyType.Boolean);
        ((ASTCondition)this.model).setRightOperand(staticBool);
        return this;
    }

    public ASTOperandArrayBuilder withRightOperandAsArray() {
        ASTOperandArrayBuilder arrayBuilder = new ASTOperandArrayBuilder(this);
        arrayBuilder.create();
        ((ASTCondition)this.model).setRightOperand((ASTOperandBase)arrayBuilder.getModel());
        return arrayBuilder;
    }

    public ASTOperandArrayBuilder withRightOperandAsArray(float ... numbers) {
        ASTOperandArrayBuilder arrayBuilder = this.withRightOperandAsArray();
        if (numbers != null && numbers.length > 0) {
            for (float num : numbers) {
                arrayBuilder.addItem(new ASTOperandStaticNumber(num));
            }
        }
        return arrayBuilder;
    }

    public ASTOperandArrayBuilder withRightOperandAsArray(String ... strings) {
        ASTOperandArrayBuilder arrayBuilder = this.withRightOperandAsArray();
        if (strings != null && strings.length > 0) {
            for (String s : strings) {
                arrayBuilder.addItem(new ASTOperandStaticString(s));
            }
        }
        return arrayBuilder;
    }

    public ASTOperandArithmeticalBuilder createRightOperandAsArithmeticalOperation() {
        ASTOperandArithmeticalBuilder arithmeticalBuilder = new ASTOperandArithmeticalBuilder(this);
        arithmeticalBuilder.create();
        ((ASTCondition)this.model).setRightOperand((ASTOperandBase)arithmeticalBuilder.getModel());
        return arithmeticalBuilder;
    }

    public ASTOperandFunctionBuilder createRightOperandAsFunction() {
        ASTOperandFunctionBuilder functionBuilder = new ASTOperandFunctionBuilder(this);
        functionBuilder.create();
        ((ASTCondition)this.model).setRightOperand((ASTOperandBase)functionBuilder.getModel());
        return functionBuilder;
    }

    public void withUnknownConditions(List<ASTConditionBase> unknownConditions) {
        ((ASTCondition)this.model).setUnresolvedConditions(unknownConditions);
    }

    public void withUnknownCondition(ASTConditionBase unknownCondition) {
        ((ASTCondition)this.model).getUnresolvedConditions().add(unknownCondition);
    }

    public ASTConditionGroupBuilder parentGroup() {
        return this.parentGroup;
    }
}

