/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.builder;

import io.openvalidation.common.ast.ASTComment;
import io.openvalidation.common.ast.ASTGlobalElement;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.builder.ASTBuilder;
import io.openvalidation.common.ast.builder.ASTBuilderBase;
import io.openvalidation.common.ast.builder.ASTRuleBuilder;
import io.openvalidation.common.ast.builder.ASTVariableBuilder;

public class ASTModelBuilder
extends ASTBuilderBase<ASTModelBuilder, ASTBuilder, ASTModel> {
    private ASTRuleBuilder ruleBuilder;
    private ASTVariableBuilder variableBuilder;

    public ASTModelBuilder() {
        super(null, ASTModel.class);
        this.create();
        this.ruleBuilder = new ASTRuleBuilder(this);
        this.variableBuilder = new ASTVariableBuilder(this);
    }

    public ASTModelBuilder(ASTBuilder parentBuilder) {
        super(parentBuilder, ASTModel.class);
        this.create();
        this.ruleBuilder = new ASTRuleBuilder(this);
        this.variableBuilder = new ASTVariableBuilder(this);
    }

    public ASTModelBuilder createComment(String ... commentLines) {
        ASTComment comment = new ASTComment(commentLines);
        this.withComment(comment);
        return this;
    }

    public ASTModelBuilder withComment(ASTComment comment) {
        ((ASTModel)this.model).add(comment);
        return this;
    }

    public ASTModelBuilder with(ASTGlobalElement element) {
        ((ASTModel)this.model).add(element);
        return this;
    }

    public ASTRuleBuilder createRule() {
        this.ruleBuilder.create();
        this.withRule((ASTRule)this.ruleBuilder.getModel());
        return this.ruleBuilder;
    }

    public ASTRuleBuilder createRule(String name, String error) {
        this.ruleBuilder.createRule(name, error);
        this.withRule((ASTRule)this.ruleBuilder.getModel());
        return this.ruleBuilder;
    }

    public ASTRuleBuilder withRule(ASTRule rule) {
        ((ASTModel)this.model).add(rule);
        return this.ruleBuilder;
    }

    public ASTVariableBuilder createVariable(String name) {
        this.variableBuilder.createVariable(name);
        this.withVariable((ASTVariable)this.variableBuilder.getModel());
        return this.variableBuilder;
    }

    public ASTVariableBuilder withVariable(ASTVariable variable) {
        ((ASTModel)this.model).add(variable);
        return this.variableBuilder;
    }

    public ASTRule getFirstRule() {
        return ((ASTModel)this.getModel()).getRules().get(0);
    }
}

