/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.builder;

import io.openvalidation.common.ast.ASTActionError;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.builder.ASTBuilderBase;
import io.openvalidation.common.ast.builder.ASTConditionBuilder;
import io.openvalidation.common.ast.builder.ASTConditionGroupBuilder;
import io.openvalidation.common.ast.builder.ASTModelBuilder;
import io.openvalidation.common.ast.condition.ASTConditionBase;

public class ASTRuleBuilder
extends ASTBuilderBase<ASTRuleBuilder, ASTModelBuilder, ASTRule> {
    private ASTConditionBuilder conditionBuilder = new ASTConditionBuilder(this);
    private ASTConditionGroupBuilder conditionGroupBuilder = new ASTConditionGroupBuilder(this);

    public ASTRuleBuilder() {
        this(null);
    }

    public ASTRuleBuilder(ASTModelBuilder prntBldr) {
        super(prntBldr, ASTRule.class);
    }

    public ASTRuleBuilder createRule(String name, String error) {
        ((ASTRuleBuilder)this.create()).withName(name).withError(error);
        return this;
    }

    public ASTConditionBuilder createCondition() {
        this.conditionBuilder.create();
        ((ASTRule)this.model).setCondition((ASTConditionBase)this.conditionBuilder.getModel());
        return this.conditionBuilder;
    }

    public ASTConditionGroupBuilder createConditionGroup() {
        this.conditionGroupBuilder.create();
        ((ASTRule)this.model).setCondition((ASTConditionBase)this.conditionGroupBuilder.getModel());
        return this.conditionGroupBuilder;
    }

    public ASTRuleBuilder withName(String name) {
        ((ASTRule)this.model).setName(name);
        return this;
    }

    public ASTRuleBuilder withError(String error) {
        ((ASTRule)this.model).setAction(new ASTActionError(error));
        return this;
    }

    public ASTRuleBuilder withError(ASTActionError error) {
        ((ASTRule)this.model).setAction(error);
        return this;
    }

    public ASTRuleBuilder withCondition(ASTConditionBase condition) {
        ((ASTRule)this.model).setCondition(condition);
        return this;
    }
}

