/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.builder;

import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.builder.ASTBuilderBase;
import io.openvalidation.common.ast.builder.ASTConditionBuilder;
import io.openvalidation.common.ast.builder.ASTModelBuilder;
import io.openvalidation.common.ast.builder.ASTOperandFunctionBuilder;
import io.openvalidation.common.ast.builder.ASTPropertyBuilder;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;

public class ASTVariableBuilder
extends ASTBuilderBase<ASTVariableBuilder, ASTModelBuilder, ASTVariable> {
    public ASTVariableBuilder() {
        super(null, ASTVariable.class);
    }

    public ASTVariableBuilder(ASTModelBuilder prntBldr) {
        super(prntBldr, ASTVariable.class);
    }

    public ASTVariableBuilder createVariable(String name) {
        ((ASTVariableBuilder)this.create()).withName(name);
        return this;
    }

    public ASTVariableBuilder withName(String name) {
        ((ASTVariable)this.model).setName(name);
        return this;
    }

    public ASTVariableBuilder withValueAsString(String value) {
        ((ASTVariable)this.model).setValue(new ASTOperandStaticString(value));
        return this;
    }

    public ASTVariableBuilder withValueAsNumber(double value) {
        ((ASTVariable)this.model).setValue(new ASTOperandStaticNumber(value));
        return this;
    }

    public ASTVariableBuilder withValueAsProperty(String ... path) {
        ((ASTVariable)this.model).setValue(new ASTOperandProperty(path));
        return this;
    }

    public ASTPropertyBuilder createValueAsProperty() {
        ASTPropertyBuilder propertyBuilder = new ASTPropertyBuilder(this);
        propertyBuilder.create();
        ((ASTVariable)this.model).setValue((ASTOperandBase)propertyBuilder.getModel());
        return propertyBuilder;
    }

    public ASTConditionBuilder createValueAsCondition() {
        ASTConditionBuilder conditionBuilder = new ASTConditionBuilder(this);
        conditionBuilder.create();
        ((ASTVariable)this.model).setValue((ASTOperandBase)conditionBuilder.getModel());
        return conditionBuilder;
    }

    public ASTOperandFunctionBuilder createValueAsFunction(String functionName) {
        ASTOperandFunctionBuilder builder = this.createValueAsFunction();
        builder.withName(functionName);
        return builder;
    }

    public ASTOperandFunctionBuilder createValueAsFunction() {
        ASTOperandFunctionBuilder functionBuilder = new ASTOperandFunctionBuilder(this);
        functionBuilder.create();
        ((ASTVariable)this.model).setValue((ASTOperandBase)functionBuilder.getModel());
        return functionBuilder;
    }

    public ASTVariableBuilder withValue(ASTOperandBase value) {
        ((ASTVariable)this.model).setValue(value);
        return this;
    }
}

