/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.condition;

import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStatic;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.NumberParsingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ASTCondition
extends ASTConditionBase {
    private int indentationLevel;
    private int relativeIndentationLevel;
    private ASTOperandBase leftOperand = null;
    private ASTOperandBase rightOperand = null;
    private ASTComparisonOperator operator = null;
    private boolean isConstrainedCondition;
    private boolean hasToBeInverted;
    private String semanticOperatorName;
    private List<ASTConditionBase> unresolvedConditions = new ArrayList<ASTConditionBase>();

    public ASTCondition() {
    }

    public ASTCondition(String originalSource) {
        this._originalSource = originalSource;
    }

    public List<ASTConditionBase> getUnresolvedConditions() {
        return this.unresolvedConditions;
    }

    public void setUnresolvedConditions(List<ASTConditionBase> unresolvedConditions) {
        this.unresolvedConditions = unresolvedConditions;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public int getRelativeIndentationLevel() {
        return this.relativeIndentationLevel;
    }

    public void setRelativeIndentationLevel(int relativeIndentationLevel) {
        this.relativeIndentationLevel = relativeIndentationLevel;
    }

    public ASTOperandBase getLeftOperand() {
        return this.leftOperand;
    }

    public ASTCondition setLeftOperand(ASTOperandBase leftOperand) {
        this.leftOperand = leftOperand;
        return this;
    }

    public ASTOperandBase getRightOperand() {
        return this.rightOperand;
    }

    public boolean hasOperator(ASTComparisonOperator operator) {
        return operator.equals((Object)this.operator);
    }

    public boolean hasRightOperand() {
        return this.getRightOperand() != null;
    }

    public boolean hasLeftOperand() {
        return this.getLeftOperand() != null;
    }

    public boolean hasRightAndLeftOperand() {
        return this.hasLeftOperand() && this.hasRightOperand();
    }

    public ASTCondition setRightOperand(ASTOperandBase rightOperand) {
        this.rightOperand = rightOperand;
        return this;
    }

    public String getLeftOperandValueAsString() {
        return this.hasLeftOperand() && this.getLeftOperand().isStaticString() ? ((ASTOperandStaticString)this.getLeftOperand()).getValue() : null;
    }

    public String getRightOperandValueAsString() {
        return this.hasRightOperand() && this.getRightOperand().isStaticString() ? ((ASTOperandStaticString)this.getRightOperand()).getValue() : null;
    }

    public ASTComparisonOperator getOperator() {
        return this.operator;
    }

    public boolean hasEqualityComparer() {
        return this.operator != null && (this.operator == ASTComparisonOperator.EQUALS || this.operator == ASTComparisonOperator.NOT_EQUALS);
    }

    public boolean hasSimpleComparisonOperator() {
        return this.operator != null && this.operator.isSimpleComparisonOperator();
    }

    public String getSemanticOperatorName() {
        return this.semanticOperatorName;
    }

    public void setSemanticOperatorName(String semanticOperator) {
        this.semanticOperatorName = semanticOperator;
    }

    public ASTCondition setOperator(ASTComparisonOperator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.add(this.getLeftOperand());
        items.add(this.getRightOperand());
        items.addAll(this.getUnresolvedConditions());
        return items;
    }

    @Override
    public List<ASTOperandProperty> getAllParentProperties() {
        List<ASTOperandProperty> properties = this.getPreconditionPropertiesFromOperand(this.leftOperand);
        properties.addAll(this.getPreconditionPropertiesFromOperand(this.rightOperand));
        return this.sortPrecoditionProperties(properties);
    }

    @Override
    public void invertOperator() {
        if (this.operator != null) {
            this.setOperator(this.getOperator().invert());
        }
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        List<ASTOperandProperty> properties;
        ArrayList<ASTOperandProperty> props = new ArrayList<ASTOperandProperty>();
        if (this.leftOperand != null && (properties = this.leftOperand.getProperties()) != null && properties.size() > 0) {
            props.addAll(properties);
        }
        if (this.rightOperand != null && (properties = this.rightOperand.getProperties()) != null && properties.size() > 0) {
            props.addAll(properties);
        }
        return props;
    }

    public List<ASTOperandVariable> getVariables() {
        ArrayList<ASTOperandVariable> vars = new ArrayList<ASTOperandVariable>();
        if (this.leftOperand instanceof ASTOperandVariable) {
            vars.add((ASTOperandVariable)this.leftOperand);
        }
        if (this.rightOperand instanceof ASTOperandVariable) {
            vars.add((ASTOperandVariable)this.rightOperand);
        }
        return vars;
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.leftOperand != null) {
            lst.addAll(this.leftOperand.collectItemsOfType(cls));
        }
        if (this.rightOperand != null) {
            lst.addAll(this.rightOperand.collectItemsOfType(cls));
        }
        return lst;
    }

    public ASTCondition resolveImplicitBooleanCondition() {
        if (this.operator == ASTComparisonOperator.EQUALS || this.operator != ASTComparisonOperator.EQUALS) {
            if (this.leftOperand != null && this.leftOperand.getDataType() == DataPropertyType.Boolean && this.rightOperand != null && this.rightOperand.getDataType() == DataPropertyType.String) {
                this.rightOperand = new ASTOperandStatic("true");
                this.rightOperand.setDataType(DataPropertyType.Boolean);
            } else if (this.leftOperand != null && this.leftOperand.getDataType() == DataPropertyType.String && this.rightOperand != null && this.rightOperand.getDataType() == DataPropertyType.Boolean) {
                this.leftOperand = this.rightOperand;
                this.rightOperand = new ASTOperandStatic("true");
                this.rightOperand.setDataType(DataPropertyType.Boolean);
            }
        }
        return this;
    }

    public boolean hasUnresolvedValues() {
        return !this.isOperandNumber(this.leftOperand) && this.isOperandNumber(this.rightOperand) || this.isOperandNumber(this.leftOperand) && !this.isOperandNumber(this.rightOperand);
    }

    public void resolveNumberValue() {
        Double dbl;
        String value;
        Double value2;
        String oprndVal;
        if (this.getLeftOperand() != null && this.getLeftOperand().isNumber() && this.rightOperand != null && this.rightOperand instanceof ASTOperandStaticString) {
            oprndVal = ((ASTOperandStaticString)this.rightOperand).getValue();
            if (NumberParsingUtils.containsNumber(oprndVal)) {
                value2 = NumberParsingUtils.extractDouble(oprndVal);
                String source = this.rightOperand.getPreprocessedSource();
                if (value2 != null) {
                    this.rightOperand = new ASTOperandStaticNumber(value2);
                    this.rightOperand.setSource(source);
                }
            }
        } else if (this.getRightOperand() != null && this.getRightOperand().isNumber() && this.leftOperand != null && this.leftOperand instanceof ASTOperandStaticString && NumberParsingUtils.containsNumber(oprndVal = ((ASTOperandStaticString)this.leftOperand).getValue())) {
            value2 = NumberParsingUtils.extractDouble(oprndVal);
            String source = this.leftOperand.getPreprocessedSource();
            if (value2 != null) {
                this.leftOperand = new ASTOperandStaticNumber(value2);
                this.leftOperand.setSource(source);
            }
        }
        if (this.getLeftOperand() != null && this.getLeftOperand().isNumber() && this.rightOperand == null) {
            String string = value = this.isConstrainedCondition ? this.getPreprocessedSource() : this.getLeftOperand().getPreprocessedSource();
            if (NumberParsingUtils.containsNumber(value) && (dbl = NumberParsingUtils.extractDouble(value)) != null) {
                this.rightOperand = new ASTOperandStaticNumber(dbl);
                this.rightOperand.setSource(value);
            }
        }
        if (this.getRightOperand() != null && this.getRightOperand().isNumber() && this.leftOperand == null) {
            String string = value = this.isConstrainedCondition ? this.getPreprocessedSource() : this.getRightOperand().getPreprocessedSource();
            if (NumberParsingUtils.containsNumber(value) && (dbl = NumberParsingUtils.extractDouble(value)) != null) {
                this.leftOperand = new ASTOperandStaticNumber(dbl);
                this.leftOperand.setSource(value);
            }
        }
    }

    private boolean isOperandNumber(ASTOperandBase operand) {
        return operand != null && operand.isNumber();
    }

    public boolean isConstrainedCondition() {
        return this.isConstrainedCondition;
    }

    public void setConstrainedCondition(boolean constrainedCondition) {
        this.isConstrainedCondition = constrainedCondition;
    }

    public boolean hasToBeInverted() {
        return this.hasToBeInverted;
    }

    public void setHasToBeInverted(boolean hasToBeInverted) {
        this.hasToBeInverted = hasToBeInverted;
    }

    @Override
    public List<ASTCondition> getAllConditions() {
        ArrayList<ASTCondition> conditions = new ArrayList<ASTCondition>();
        conditions.add(this);
        return conditions;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType() + "\n");
        sb.append(this.space(level + 1) + "INDENTATION: " + this.getIndentationLevel() + "\n");
        if (this.getConnector() != null) {
            sb.append(this.space(level + 1) + "CONNECTOR: " + (Object)((Object)this.getConnector()) + "\n");
        }
        sb.append(this.space(level + 1) + "LEFT: \n");
        if (this.leftOperand != null) {
            sb.append(this.leftOperand.print(level + 2));
        }
        sb.append(this.space(level + 1) + "OPERATOR: " + (Object)((Object)this.operator) + "\n");
        sb.append(this.space(level + 1) + "RIGHT: \n");
        if (this.rightOperand != null) {
            sb.append(this.rightOperand.print(level + 2));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTCondition)) {
            return false;
        }
        ASTCondition that = (ASTCondition)o;
        return this.getIndentationLevel() == that.getIndentationLevel() && Objects.equals(this.getLeftOperand(), that.getLeftOperand()) && Objects.equals(this.getRightOperand(), that.getRightOperand()) && this.getOperator() == that.getOperator() && Objects.equals((Object)this.getConnector(), (Object)that.getConnector()) && Objects.equals(this.getPreprocessedSource(), that.getPreprocessedSource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getConnector() != null) {
            sb.append((Object)this.getConnector()).append(" ");
        }
        sb.append("[");
        if (this.leftOperand != null) {
            sb.append(this.leftOperand.toString()).append(" ");
        }
        if (this.operator != null) {
            sb.append((Object)this.operator).append(" ");
        }
        if (this.rightOperand != null) {
            sb.append(this.rightOperand.toString()).append(" ");
        }
        return sb.toString().replaceAll("([ ]+)$", "] ");
    }
}

