/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.condition;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ASTConditionGroup
extends ASTConditionBase {
    private boolean isInverted;
    private List<ASTConditionBase> conditions = new ArrayList<ASTConditionBase>();

    public List<ASTConditionBase> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ASTConditionBase> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(ASTConditionBase condition) {
        this.conditions.add(condition);
    }

    public void addConditions(List<ASTCondition> conditions) {
        this.conditions.addAll(conditions);
    }

    public boolean hasConstrainedCondition() {
        for (ASTConditionBase cnd : this.conditions) {
            if (cnd instanceof ASTConditionGroup && ((ASTConditionGroup)cnd).hasConstrainedCondition()) {
                return true;
            }
            if (!(cnd instanceof ASTCondition) || !((ASTCondition)cnd).isConstrainedCondition()) continue;
            return true;
        }
        return false;
    }

    public void invertConnector() {
        if (!this.isInverted) {
            this.isInverted = true;
            for (ASTConditionBase cnd : this.conditions) {
                if (cnd.getConnector() != null && cnd.getConnector() != ASTConditionConnector.UNLESS) {
                    cnd.setConnector(cnd.getConnector() == ASTConditionConnector.AND ? ASTConditionConnector.OR : ASTConditionConnector.AND);
                }
                if (!(cnd instanceof ASTConditionGroup)) continue;
                ((ASTConditionGroup)cnd).invertConnector();
            }
        }
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.addAll(this.getConditions());
        return items;
    }

    @Override
    public List<ASTOperandProperty> getAllParentProperties() {
        List<ASTOperandProperty> properties = this.getConditions().stream().flatMap(c -> c.getAllParentProperties().stream()).collect(Collectors.toList());
        return this.sortPrecoditionProperties(properties);
    }

    @Override
    public void invertOperator() {
        this.getConditions().forEach(c -> c.invertOperator());
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        List<ASTOperandProperty> props = this.conditions.stream().filter(c -> c.getProperties() != null).flatMap(c -> c.getProperties().stream()).collect(Collectors.toList());
        return props;
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        lst.addAll(this.conditions.stream().flatMap(c -> c.collectItemsOfType(cls).stream()).collect(Collectors.toList()));
        return lst;
    }

    @Override
    public List<ASTCondition> getAllConditions() {
        ArrayList<ASTCondition> conditions = new ArrayList<ASTCondition>();
        for (ASTConditionBase condition : this.getConditions()) {
            conditions.addAll(condition.getAllConditions());
        }
        return conditions;
    }

    public List<ASTConditionGroup> filterConditionGroups() {
        ArrayList<ASTConditionGroup> conditionGroups = new ArrayList<ASTConditionGroup>();
        for (ASTConditionBase base : this.getConditions()) {
            if (!(base instanceof ASTConditionGroup)) continue;
            conditionGroups.add((ASTConditionGroup)base);
        }
        return conditionGroups;
    }

    public List<ASTCondition> filterConditions() {
        ArrayList<ASTCondition> conditions = new ArrayList<ASTCondition>();
        for (ASTConditionBase base : this.getConditions()) {
            if (!(base instanceof ASTCondition)) continue;
            conditions.add((ASTCondition)base);
        }
        return conditions;
    }

    public void UpdateSources() {
        StringBuilder sb = new StringBuilder();
        for (ASTConditionBase condition : this.conditions) {
            if (condition instanceof ASTConditionGroup && io.openvalidation.common.utils.StringUtils.isNullOrEmpty(condition.getPreprocessedSource())) {
                ((ASTConditionGroup)condition).UpdateSources();
            }
            sb.append(condition.getPreprocessedSource());
        }
        if (StringUtils.isEmpty((String)this.getPreprocessedSource())) {
            this.setSource(sb.toString());
        }
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType() + "\n");
        sb.append(this.space(level + 1) + "CONNECTOR: " + (Object)((Object)this.getConnector()) + "\n");
        for (ASTConditionBase condition : this.conditions) {
            sb.append(condition.print(level + 1));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getConnector() != null) {
            sb.append((Object)this.getConnector()).append(" ");
        }
        sb.append("( ");
        for (ASTConditionBase element : this.conditions) {
            sb.append(element.toString());
        }
        sb.append(") ");
        return sb.toString();
    }
}

