/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.operand;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaProperty;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ASTOperandFunction
extends ASTOperandBase {
    private String name;
    protected List<ASTOperandBase> parameters = new ArrayList<ASTOperandBase>();
    protected Map<String, DataPropertyType> _returnTypes = new HashMap<String, DataPropertyType>();

    public ASTOperandFunction() {
        this._returnTypes.put("SUM_OF", DataPropertyType.Decimal);
        this._returnTypes.put("GET_ARRAY_OF", DataPropertyType.Array);
    }

    public ASTOperandFunction(String name, ASTOperandBase ... parameters) {
        this();
        this.setName(name);
        if (parameters != null) {
            this.setParameters(Arrays.stream(parameters).collect(Collectors.toList()));
        }
    }

    public ASTOperandFunction addParameter(ASTOperandBase parameter) {
        this.parameters.add(parameter);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this._returnTypes.containsKey(name)) {
            this.setDataType(this._returnTypes.get(name));
        }
        this.name = name;
    }

    public List<ASTOperandBase> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ASTOperandBase> parameters) {
        this.parameters = parameters;
    }

    @Override
    public DataPropertyType getDataType() {
        return super.getDataType() == null ? DataPropertyType.Unknown : super.getDataType();
    }

    public DataPropertyType getArrayContentType() {
        DataPropertyType type = null;
        if (this.getName().equals("GET_ARRAY_OF")) {
            ASTOperandBase secondParam;
            if (this.parameters.size() > 1 && (secondParam = this.parameters.get(1)) instanceof ASTOperandLambdaProperty) {
                type = ((ASTOperandLambdaProperty)secondParam).getProperty().getDataType();
            }
        } else if (this.getDataType() == DataPropertyType.Array && this.parameters.size() > 0) {
            ASTOperandBase firstParam = this.parameters.get(0);
            if (firstParam instanceof ASTOperandProperty) {
                type = ((ASTOperandProperty)firstParam).getArrayContentType();
            } else if (firstParam instanceof ASTOperandVariable) {
                type = ((ASTOperandVariable)firstParam).getArrayContentType();
            } else if (firstParam instanceof ASTOperandFunction) {
                type = ((ASTOperandFunction)firstParam).getArrayContentType();
            }
        }
        return type;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.addAll(this.getParameters());
        return items;
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        ArrayList<ASTOperandProperty> props = new ArrayList<ASTOperandProperty>();
        for (ASTOperandBase param : this.parameters) {
            List<ASTOperandProperty> availableProperties = param.getProperties();
            if (availableProperties == null || availableProperties.size() <= 0) continue;
            props.addAll(availableProperties);
        }
        return props;
    }

    public List<ASTOperandVariable> getVariables() {
        ArrayList<ASTOperandVariable> vars = new ArrayList<ASTOperandVariable>();
        for (ASTOperandBase param : this.parameters) {
            if (!(param instanceof ASTOperandVariable)) continue;
            vars.add((ASTOperandVariable)param);
        }
        return vars;
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.parameters != null && this.parameters.size() > 0) {
            lst.addAll(this.parameters.stream().flatMap(c -> c.collectItemsOfType(cls).stream()).collect(Collectors.toList()));
        }
        return lst;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType() + "\n");
        sb.append(this.space(level + 1) + "NAME: " + this.getName() + " \n");
        sb.append(this.space(level + 1) + "DataType: " + (Object)((Object)this.getDataType()) + "\n");
        for (ASTOperandBase param : this.getParameters()) {
            sb.append(param.print(level + 1));
        }
        sb.append("\n");
        return sb.toString();
    }

    public void replaceFirstParameter(ASTOperandFunction newParam) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<ASTOperandBase>());
        }
        if (this.getParameters().size() > 0) {
            this.getParameters().remove(0);
            this.getParameters().add(0, newParam);
        } else {
            this.addParameter(newParam);
        }
    }
}

