/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.operand.arithmetical;

import io.openvalidation.common.ast.ASTArithmeticalOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalItemBase;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ASTOperandArithmeticalOperation
extends ASTOperandArithmeticalItemBase {
    private List<ASTOperandArithmeticalItemBase> items = new ArrayList<ASTOperandArithmeticalItemBase>();

    public ASTOperandArithmeticalOperation add(ASTOperandArithmeticalItemBase item, ASTArithmeticalOperator operator) {
        item.operator = operator;
        return this.add(item);
    }

    public ASTOperandArithmeticalOperation add(ASTOperandArithmeticalItemBase item) {
        this.items.add(item);
        this._preprocessedSource = item.getPreprocessedSource();
        return this;
    }

    public List<ASTOperandArithmeticalItemBase> getItems() {
        return this.items;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.addAll(this.getItems());
        return items;
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        ArrayList<ASTOperandProperty> props = new ArrayList<ASTOperandProperty>();
        if (this.items != null) {
            for (int x = 0; x < this.items.size(); ++x) {
                List<ASTOperandProperty> properties = this.items.get(x).getProperties();
                if (properties == null || properties.size() <= 0) continue;
                props.addAll(properties);
            }
        }
        return props;
    }

    public List<ASTOperandArithmeticalOperation> filterOperations() {
        ArrayList<ASTOperandArithmeticalOperation> operations = new ArrayList<ASTOperandArithmeticalOperation>();
        for (ASTOperandArithmeticalItemBase item : this.getItems()) {
            if (!(item instanceof ASTOperandArithmeticalOperation)) continue;
            operations.add((ASTOperandArithmeticalOperation)item);
        }
        return operations;
    }

    public List<ASTOperandArithmeticalItemBase> filterNonOperations() {
        ArrayList<ASTOperandArithmeticalItemBase> nonOperations = new ArrayList<ASTOperandArithmeticalItemBase>();
        for (ASTOperandArithmeticalItemBase item : this.getItems()) {
            if (item instanceof ASTOperandArithmeticalOperation) continue;
            nonOperations.add(item);
        }
        return nonOperations;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        if (this.getOperator() != null) {
            sb.append(super.space(level) + this.getOperator().name() + "\n");
        }
        for (ASTOperandArithmeticalItemBase item : this.getItems()) {
            sb.append(item.print(level + 1));
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.getItems() != null && this.getItems().size() > 1) {
            lst.addAll(this.getItems().stream().flatMap(c -> c.collectItemsOfType(cls).stream()).collect(Collectors.toList()));
        }
        return lst;
    }

    @Override
    public boolean isNumber() {
        return this.items.stream().allMatch(i -> i.isNumber());
    }

    public void updateSources() {
        StringBuilder sb = new StringBuilder();
        for (ASTOperandArithmeticalItemBase item : this.items) {
            if (item instanceof ASTOperandArithmeticalOperation) {
                ((ASTOperandArithmeticalOperation)item).updateSources();
            }
            sb.append(item.getPreprocessedSource());
        }
        this.setSource(sb.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ASTOperandArithmeticalItemBase item : this.items) {
            if (item instanceof ASTOperandArithmeticalOperation) {
                if (item.getOperator() != null) {
                    sb.append(item.getOperator().toString()).append(" ");
                }
                sb.append("(").append(item.toString()).append(") ");
                continue;
            }
            sb.append(item).append(" ");
        }
        return sb.toString();
    }
}

