/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.operand.arithmetical;

import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalItemBase;
import io.openvalidation.common.utils.StringUtils;

public class ASTOperandArithmeticalStringItem
extends ASTOperandArithmeticalItemBase {
    public ASTOperandArithmeticalStringItem(String value) {
        if (!StringUtils.isNullOrEmpty(value)) {
            this.operand = new ASTOperandStaticString(value);
        }
    }

    public ASTOperandArithmeticalStringItem(ASTOperandStaticString operand) {
        this.operand = operand;
    }

    @Override
    public ASTOperandStaticString getOperand() {
        return (ASTOperandStaticString)this.operand;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        if (this.getOperator() != null) {
            sb.append(super.space(level) + this.getOperator().name() + "\n");
        }
        sb.append(this.space(level) + this.getType() + " : " + this.getOperand().getValue());
        return sb.toString();
    }
}

