/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.operand.lambda;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import java.util.ArrayList;
import java.util.List;

public abstract class ASTOperandLambdaExpression
extends ASTOperandBase {
    private ASTOperandBase _operand;
    protected String lambdaToken;

    public ASTOperandBase getOperand() {
        return this._operand;
    }

    public void setOperand(ASTOperandBase operand) {
        this._operand = operand;
        this.updateLambdaRecursively();
    }

    public String getLambdaToken() {
        return this.lambdaToken;
    }

    public void setLambdaToken(String token) {
        this.lambdaToken = token;
        this.updateLambdaRecursively();
    }

    public void updateLambdaRecursively() {
        this.walk(ctx -> {
            ASTOperandProperty prop = ctx.getCurrentAs(ASTOperandProperty.class);
            if (prop != null) {
                prop.setLambdaToken(this.getLambdaToken());
            }
        }, ASTOperandProperty.class);
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.getOperand() != null) {
            lst.addAll(this.getOperand().collectItemsOfType(cls));
        }
        return lst;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.add(this.getOperand());
        return items;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType() + "\n");
        sb.append(this.space(level + 1) + "DataType : " + (Object)((Object)this.getDataType()) + "\n");
        return sb.toString();
    }
}

