/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.ast.operand.property;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.property.ASTPropertyPart;
import io.openvalidation.common.ast.operand.property.ASTPropertyStaticPart;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ASTOperandProperty
extends ASTOperandBase {
    protected List<ASTPropertyPart> path = new ArrayList<ASTPropertyPart>();
    protected String lambdaToken;
    private DataPropertyType _arrayContentType;

    public ASTOperandProperty() {
    }

    public ASTOperandProperty(String ... parts) {
        this();
        this.add(parts);
    }

    public ASTOperandProperty(ASTOperandProperty property) {
        this();
        if (property != null) {
            this.setPath(property.getPath());
            this.setLambdaToken(property.getLambdaToken());
            this.setDataType(property.getDataType());
        }
    }

    public String getLambdaToken() {
        return this.lambdaToken;
    }

    public void setLambdaToken(String token) {
        this.lambdaToken = token;
    }

    public DataPropertyType getArrayContentType() {
        return this._arrayContentType;
    }

    public void setArrayContentType(DataPropertyType _arrayContentType) {
        this._arrayContentType = _arrayContentType;
    }

    public List<ASTPropertyPart> getPath() {
        return this.path;
    }

    public void setPath(List<ASTPropertyPart> path) {
        this.path = path;
    }

    public String getPathAsString() {
        if (this.path.size() > 0) {
            return String.join((CharSequence)".", this.getPath().stream().map(p -> p.getPart()).collect(Collectors.toList()));
        }
        return "";
    }

    public ASTOperandProperty add(ASTPropertyPart part) {
        this.path.add(part);
        return this;
    }

    public ASTOperandProperty add(String ... parts) {
        if (parts != null) {
            for (String p : parts) {
                ASTPropertyStaticPart propPart = new ASTPropertyStaticPart(p);
                propPart.setSource(p);
                this.path.add(propPart);
            }
        }
        return this;
    }

    public List<ASTOperandProperty> getAllParentProperties() {
        ArrayList<ASTOperandProperty> parents = new ArrayList<ASTOperandProperty>();
        if (this.path.size() > 1) {
            for (ASTOperandProperty parent = this.getParentProperty(); parent != null; parent = parent.getParentProperty()) {
                parents.add(new ASTOperandProperty(parent));
            }
        }
        parents.sort(Comparator.comparing(c -> c.getPath().size()));
        return parents;
    }

    public ASTOperandProperty getParentProperty() {
        ASTOperandProperty prop = null;
        if (this.path != null && this.path.size() > 1) {
            int size = this.path.size();
            prop = new ASTOperandProperty();
            this.path.stream().limit(size - 1).forEach(prop::add);
        }
        return prop;
    }

    public String[] getPathAsArray() {
        if (this.getPath() != null) {
            return this.getPath().stream().map(p -> p.getPart().toString()).collect(Collectors.toList()).toArray(new String[0]);
        }
        return null;
    }

    @Override
    public List<ASTItem> children() {
        ArrayList<ASTItem> items = new ArrayList<ASTItem>();
        items.addAll(this.getPath());
        return items;
    }

    @Override
    public List<ASTOperandProperty> getProperties() {
        ArrayList<ASTOperandProperty> props = new ArrayList<ASTOperandProperty>();
        props.add(this);
        return props;
    }

    @Override
    public <T extends ASTItem> List<T> collectItemsOfType(Class<T> cls) {
        List<T> lst = super.collectItemsOfType(cls);
        if (this.path != null && this.path.size() > 1) {
            this.path.stream().flatMap(c -> c.collectItemsOfType(cls).stream()).collect(Collectors.toList());
        }
        return lst;
    }

    @Override
    public String print(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.space(level) + this.getType() + " : " + this.getPathAsString() + "\n");
        sb.append(this.space(level + 1) + "DataType : " + (Object)((Object)this.getDataType()) + "\n");
        if (!StringUtils.isNullOrEmpty(this.getLambdaToken())) {
            sb.append(this.space(level + 1) + "Lambda : " + this.getLambdaToken() + "\n");
        }
        if (this.getPath() != null && this.getPath().size() > 0) {
            for (ASTPropertyPart part : this.getPath()) {
                if (part == null) continue;
                sb.append(part.print(level + 2));
            }
        }
        return sb.toString();
    }
}

