/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.converter;

import io.openvalidation.common.converter.ISchemaConverter;
import io.openvalidation.common.data.DataProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.data.DataSchema;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.utils.JsonUtils;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class Jsonschema2DataSchemaConverter
implements ISchemaConverter {
    private String _rawSchema;
    private static int MAX_DEEP = 10;

    public Jsonschema2DataSchemaConverter(String rawSchema) {
        this._rawSchema = rawSchema;
    }

    @Override
    public DataSchema convert() throws Exception {
        DataSchema schema = new DataSchema();
        try {
            JSONObject json = JsonUtils.loadJson(this._rawSchema);
            if (json.keySet() == null || json.keySet().size() < 1) {
                throw new OpenValidationException("JSON Schema schould not be empty: \n" + this._rawSchema + "\n");
            }
            this.fillSchema(json, schema, "", 0);
        }
        catch (OpenValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenValidationException("invalid JSON Schema argument: \n" + this._rawSchema + "\n", "invalid JSON Schema argument: \n" + this._rawSchema + "\n", e);
        }
        return schema;
    }

    private void fillSchema(JSONObject object, DataSchema schema, String path, int level) {
        JSONObject properties = object.getJSONObject("properties");
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            JSONObject arrayItems;
            DataPropertyType arrayItemsType;
            String fullName;
            String key;
            String name = key = (String)iterator.next();
            JSONObject prop = (JSONObject)properties.get(key);
            DataPropertyType type = JsonUtils.parseTypeBySchemaProperty(prop);
            DataPropertyType arrayContentType = type == DataPropertyType.Array ? JsonUtils.parseTypeBySchemaProperty((JSONObject)prop.get("items")) : null;
            String pth = path != null && path.length() > 0 ? path : "";
            String string = fullName = path != null && path.length() > 0 ? path + "." + name : name;
            if (type == DataPropertyType.Enum) {
                JSONArray arr = (JSONArray)prop.get("enum");
                DataProperty p = new DataProperty(name, path, type);
                p.setEnumValues((String[])arr.toList().stream().map(a -> a.toString()).toArray(String[]::new));
                schema.addProperty(p);
            } else {
                schema.addProperty(name, pth, type, arrayContentType);
            }
            if (type == DataPropertyType.Object) {
                this.fillSchema(prop, schema, fullName, level + 1);
                continue;
            }
            if (type != DataPropertyType.Array || (arrayItemsType = JsonUtils.parseTypeBySchemaProperty(arrayItems = prop.getJSONObject("items"))) != DataPropertyType.Object) continue;
            this.fillSchema(arrayItems, schema, fullName, level + 1);
        }
    }
}

