/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.converter;

import io.openvalidation.common.converter.ISchemaConverter;
import io.openvalidation.common.converter.Json2DataSchemaConverter;
import io.openvalidation.common.converter.Jsonschema2DataSchemaConverter;
import io.openvalidation.common.data.DataSchema;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.utils.JsonUtils;

public class SchemaConverterFactory {
    public static ISchemaConverter create(String rawSchema) throws Exception {
        if (JsonUtils.isJsonSchema(rawSchema)) {
            return new Jsonschema2DataSchemaConverter(rawSchema);
        }
        if (JsonUtils.isJsonData(rawSchema)) {
            return new Json2DataSchemaConverter(rawSchema);
        }
        throw new OpenValidationException("invalid JSON Schema Format. Should be json data or json schema in json or yaml format!\n" + rawSchema);
    }

    public static DataSchema convert(String rawSchema) throws Exception {
        ISchemaConverter schemaConverter = SchemaConverterFactory.create(rawSchema);
        DataSchema schema = schemaConverter.convert();
        schema.determineUniqueProperties();
        return schema;
    }
}

