/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.data;

import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.LINQ;

public class DataArrayProperty
extends DataPropertyBase {
    private String _arrayPath;
    private String _propertyPath;

    public DataArrayProperty(String name, String propertyPath, String arrayPath, DataPropertyType type) {
        this(name, propertyPath, arrayPath, type, null);
    }

    public DataArrayProperty(String name, String propertyPath, String arrayPath, DataPropertyType type, DataPropertyType arrayContentType) {
        super(name, type, arrayContentType);
        this.setFullName(propertyPath != null && propertyPath.length() > 0 ? arrayPath + "." + propertyPath + "." + name : arrayPath + "." + name);
        this._arrayPath = arrayPath;
        this._propertyPath = propertyPath;
    }

    public String getPropertyPath() {
        return this._propertyPath;
    }

    public String getArrayPath() {
        return this._arrayPath;
    }

    public String getFullPathExceptArrayPath() {
        return this._propertyPath != null && this._propertyPath.length() > 0 ? this._propertyPath + "." + this.getName() : this.getName();
    }

    public String[] getFullPathExceptArrayPathAsArray() {
        return this.getFullPathExceptArrayPath().split("\\.");
    }

    public String[] getPropertyPathAsList() {
        if (this.getPropertyPath() != null) {
            return this.getPropertyPath().split("\\.");
        }
        return null;
    }

    public String[] getArrayPathAsArray() {
        if (this.getArrayPath() == null) {
            return null;
        }
        if (this.getArrayPath().contains(".")) {
            return this.getArrayPath().split("\\.");
        }
        return LINQ.array(this.getArrayPath());
    }

    public String[] getFullPathAsArray() {
        StringBuilder fullPath = new StringBuilder();
        if (this._arrayPath != null && !this._arrayPath.isEmpty()) {
            fullPath.append(this._arrayPath).append(".");
        }
        if (this._propertyPath != null && !this._propertyPath.isEmpty()) {
            fullPath.append(this._propertyPath).append(".");
        }
        fullPath.append(this.getName());
        return fullPath.toString().split("\\.");
    }
}

