/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.data;

import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataPropertyType;
import java.util.ArrayList;
import java.util.Arrays;

public class DataProperty
extends DataPropertyBase {
    private String _path;
    private String[] _enumValues;
    private DataProperty _propOfArray;

    public DataProperty(String name, String path, DataPropertyType type) {
        this(name, path, type, null);
    }

    public DataProperty(String name, String path, DataPropertyType type, DataPropertyType arrayContentType) {
        super(name, type, arrayContentType);
        this._path = path;
        this.setFullName(this._path != null && this._path.length() > 0 ? this._path + "." + this.getName() : this.getName());
    }

    public void setEnumValues(String[] values) {
        this._enumValues = values;
    }

    public void setPropertyOfArray(DataProperty prop) {
        this._propOfArray = prop;
    }

    public String getPath() {
        return this._path;
    }

    public String[] getEnumValues() {
        return this._enumValues;
    }

    public DataProperty getPropertyOfArray() {
        return this._propOfArray;
    }

    public DataPropertyType getTypeOfArray() {
        return this._propOfArray != null ? this._propOfArray.getType() : null;
    }

    public String[] getFullNameAsParts() {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.getPath() != null && this.getPath().length() > 0) {
            Arrays.stream(this.getPath().split("\\.")).forEach(s -> parts.add(s.trim()));
        }
        parts.add(this.getName());
        return parts.toArray(new String[0]);
    }
}

