/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.data;

import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.data.DataArrayProperty;
import io.openvalidation.common.data.DataProperty;
import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.data.DataSemanticOperator;
import io.openvalidation.common.data.DataVariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DataSchema {
    private final String marker = "#123#<><><>#123#";
    private List<DataPropertyBase> _properties = new ArrayList<DataPropertyBase>();
    private HashMap<String, DataProperty> uniqueProperties = new HashMap();

    public void completeWithVariables(List<DataVariableReference> dataVariableReferences) {
        this.addVariables(dataVariableReferences);
        this.sort();
    }

    public void complete(List<DataPropertyBase> dataproperties) {
        this._properties.addAll(dataproperties);
        this.sort();
    }

    public void appendSemanticOperators(List<DataSemanticOperator> operators) {
        this._properties.addAll(operators);
    }

    public void add(DataPropertyBase property) {
        this._properties.add(property);
    }

    public void addProperty(DataProperty prop) {
        this._properties.add(prop);
    }

    public void addProperty(String name, String path, DataPropertyType type, DataPropertyType arrayCntType) {
        DataPropertyType arrayContentType;
        DataPropertyBase prop = null;
        DataPropertyBase parent = this.getArrayParentProperty(path);
        DataPropertyType dataPropertyType = arrayContentType = type == DataPropertyType.Array ? arrayCntType : null;
        if (parent != null) {
            String propPath = parent instanceof DataArrayProperty ? ((DataArrayProperty)parent).getFullPathExceptArrayPath() : "";
            String arrayPath = parent instanceof DataArrayProperty ? ((DataArrayProperty)parent).getArrayPath() : path;
            prop = new DataArrayProperty(name, propPath, arrayPath, type, arrayContentType);
        } else {
            prop = new DataProperty(name, path, type, arrayContentType);
        }
        this._properties.add(prop);
    }

    public void addProperty(String name, String path, DataPropertyType type) {
        this.addProperty(name, path, type, null);
    }

    public void addVariable(String name, DataPropertyType type) {
        this.addVariable(new DataVariableReference(name, type));
    }

    public void addVariable(DataVariableReference variable) {
        this._properties.add(variable);
    }

    public void addSemanticOperator(String name, String operandName, DataPropertyType type, ASTComparisonOperator operator) {
        this.add(new DataSemanticOperator(name, operandName, type, operator));
    }

    public void addVariables(List<DataVariableReference> variables) {
        this._properties.addAll(variables);
    }

    public DataPropertyType assertVariableType(DataVariableReference ref) {
        Optional<DataPropertyBase> firstPlausibleMatch = this._properties.stream().filter(prop -> prop != ref && ref.getOriginText().toLowerCase().contains(prop.getFullNameLowerCase())).findFirst();
        if (firstPlausibleMatch.isPresent()) {
            return firstPlausibleMatch.get().getType();
        }
        return DataPropertyType.String;
    }

    public List<DataProperty> getProperties() {
        return this._properties.stream().filter(p -> p instanceof DataProperty).map(p -> (DataProperty)p).collect(Collectors.toList());
    }

    public List<DataSemanticOperator> getSemanticOperators() {
        return this._properties.stream().filter(p -> p instanceof DataSemanticOperator).map(p -> (DataSemanticOperator)p).collect(Collectors.toList());
    }

    public List<DataPropertyBase> getAllProperties() {
        return this._properties.stream().filter(p -> p instanceof DataProperty || p instanceof DataArrayProperty).collect(Collectors.toList());
    }

    public List<DataVariableReference> getVariableReferences() {
        return this._properties.stream().filter(p -> p instanceof DataVariableReference).map(p -> (DataVariableReference)p).collect(Collectors.toList());
    }

    public List<DataArrayProperty> getArrayProperties() {
        return this._properties.stream().filter(p -> p instanceof DataArrayProperty).map(p -> (DataArrayProperty)p).collect(Collectors.toList());
    }

    public boolean isArrayAccessor(String path) {
        if (path.contains(".")) {
            String pth = path.substring(0, path.lastIndexOf("."));
            Optional<DataPropertyBase> prop = this._properties.stream().filter(p -> p.getType() == DataPropertyType.Array).filter(p -> p.getFullName().toLowerCase().equals(pth.toLowerCase())).findFirst();
            return prop != null && prop.isPresent();
        }
        return false;
    }

    public List<String> getAllNames() {
        return this._properties.stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public boolean exists(String fullName) {
        DataPropertyBase prop = this.findByFullName(fullName);
        return prop != null;
    }

    public boolean oneOf(String name) {
        if (name != null) {
            for (String n : name.split(" ")) {
                if (!this.exists(n)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLambdaPropertyOfArray(String partialPropertyName) {
        if (this.getArrayProperties() != null && partialPropertyName != null && partialPropertyName.trim().length() > 0) {
            return this.getArrayProperties().stream().anyMatch(a -> a.getFullNameLowerCase().endsWith(partialPropertyName.trim()));
        }
        return false;
    }

    public boolean isPropertyOfArray(String fullName) {
        return this.getArrayParentProperty(fullName) != null;
    }

    public DataPropertyBase getArrayParentProperty(String fullName) {
        DataPropertyBase prop;
        if (fullName != null && fullName.length() > 0 && this.exists(fullName) && (prop = this.findByFullName(fullName)) != null && (prop.getType() == DataPropertyType.Array || prop instanceof DataArrayProperty)) {
            return prop;
        }
        return null;
    }

    public List<DataProperty> getPropertiesByPath(String path) {
        return this.getProperties().stream().filter(p -> p.getPath().toLowerCase().equals(path.toLowerCase())).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        List<DataPropertyBase> dataProperties = this.getAllProperties();
        for (int i = 0; i < dataProperties.size(); ++i) {
            sb.append(dataProperties.get(i).toString());
            if (i >= dataProperties.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("] [");
        List<DataVariableReference> references = this.getVariableReferences();
        for (int i = 0; i < references.size(); ++i) {
            sb.append(references.get(i).toString());
            if (i >= references.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void determineUniqueProperties() {
        List<DataProperty> properties = this.getProperties();
        for (DataProperty property : properties) {
            String propertyName = property.getName();
            String propertyPath = property.getPath();
            boolean unique = true;
            for (int j = 0; j < properties.size(); ++j) {
                DataProperty otherProp = properties.get(j);
                if (otherProp.getFullName().startsWith(propertyPath)) {
                    int nextPartPos;
                    for (int k = nextPartPos = property.getFullNameAsParts().length; k < otherProp.getFullNameAsParts().length; ++k) {
                        if (!otherProp.getFullNameAsParts()[k].equals(propertyName)) continue;
                        unique = false;
                    }
                } else if (otherProp.getFullName().contains(propertyName)) {
                    unique = false;
                }
                if (!unique) break;
            }
            if (!unique) continue;
            this.uniqueProperties.put(propertyName, property);
        }
    }

    public List<DataPropertyBase> filterInScope(DataProperty property) {
        return this.filterInScope(property.getFullNameLowerCase());
    }

    public List<DataPropertyBase> filterInScope(DataArrayProperty property) {
        return this.filterInScope(property.getFullNameLowerCase());
    }

    public List<DataPropertyBase> filterInScope(String propertyPath) {
        return this._properties.stream().filter(p -> p instanceof DataVariableReference || p.getFullNameLowerCase().startsWith(propertyPath.toLowerCase()) && !p.getFullNameLowerCase().equals(propertyPath.toLowerCase())).collect(Collectors.toList());
    }

    public DataPropertyBase resolve(String content, String scopePropertyPath) {
        DataPropertyBase resolvedProperty = null;
        if (scopePropertyPath != null) {
            resolvedProperty = !scopePropertyPath.isEmpty() ? this.resolve(content, scopePropertyPath, this.filterInScope(scopePropertyPath)) : this.resolve(content);
        }
        return resolvedProperty;
    }

    public DataPropertyBase resolve(String content, DataProperty scopeProperty) {
        return this.resolve(content, scopeProperty.getFullNameLowerCase());
    }

    public DataPropertyBase resolve(String content, DataArrayProperty scopeProperty) {
        return this.resolve(content, scopeProperty.getFullNameLowerCase());
    }

    public DataPropertyBase resolve(String content) {
        return this.resolve(content, null, this._properties);
    }

    public DataPropertyBase resolve(String content, String scopePropertyPath, List<DataPropertyBase> properties) {
        if (content != null) {
            DataPropertyBase property;
            String scopePrefix = scopePropertyPath != null && !scopePropertyPath.isEmpty() ? scopePropertyPath.toLowerCase() + "." : "";
            String cnt = this.maskInput(content);
            Optional<DataPropertyBase> prop = properties.stream().filter(p -> {
                if (p instanceof DataVariableReference) {
                    return cnt.contains("#123#<><><>#123#" + p.getFullNameLowerCase().replace(" ", "#123#<><><>#123#") + "#123#<><><>#123#");
                }
                if (p.getFullNameLowerCase().startsWith(scopePrefix)) {
                    return cnt.contains("#123#<><><>#123#" + p.getFullNameLowerCase().replaceFirst(scopePrefix, "").replace(" ", "#123#<><><>#123#") + "#123#<><><>#123#");
                }
                return false;
            }).findFirst();
            DataPropertyBase dataPropertyBase = property = prop.isPresent() ? prop.get() : null;
            if (property != null) {
                return property;
            }
            DataPropertyBase uniqueProperty = this.lookUpInUniqueProperties(content);
            return uniqueProperty;
        }
        return null;
    }

    public List<DataPropertyBase> resolveAll(String content) {
        if (content != null) {
            Map<String, DataPropertyBase> explicitProps = this.resolveAllExplicitProperties(content);
            Map<String, DataPropertyBase> uniqueProps = this.resolveAllUniqueProperties(content);
            Map<String, DataPropertyBase> shortcutProps = this.resolveAllShortcutProperties(content);
            HashMap<String, DataPropertyBase> allResolved = new HashMap<String, DataPropertyBase>();
            allResolved.putAll(explicitProps);
            allResolved.putAll(uniqueProps);
            allResolved.putAll(shortcutProps);
            return new ArrayList<DataPropertyBase>(allResolved.values());
        }
        return null;
    }

    private Map<String, DataPropertyBase> resolveAllExplicitProperties(String inputContent) {
        String content = this.maskInput(inputContent);
        return this._properties.stream().filter(p -> content.contains("#123#<><><>#123#" + p.getFullNameLowerCase().replace(" ", "#123#<><><>#123#") + "#123#<><><>#123#")).collect(Collectors.toMap(DataPropertyBase::getFullName, p -> p));
    }

    private Map<String, DataPropertyBase> resolveAllUniqueProperties(String inputContent) {
        String content = this.maskInput(inputContent);
        return this.uniqueProperties.entrySet().stream().filter(p -> content.contains("#123#<><><>#123#" + ((String)p.getKey()).toLowerCase().replace(" ", "#123#<><><>#123#").replace("_", "#123#<><><>#123#") + "#123#<><><>#123#")).map(e -> (DataProperty)e.getValue()).collect(Collectors.toMap(p -> p.getFullName(), p -> p));
    }

    private Map<String, DataPropertyBase> resolveAllShortcutProperties(String inputContent) {
        String content = this.maskInput(inputContent);
        List<DataProperty> allShortcutsFromUnique = this.lookUpAllShortCutAtStart(content);
        if (!allShortcutsFromUnique.isEmpty()) {
            for (DataProperty shortcutProperty : allShortcutsFromUnique) {
                if (shortcutProperty.getPath().isEmpty()) continue;
                content = content.replaceAll("#123#<><><>#123#" + shortcutProperty.getName() + "\\.", "#123#<><><>#123#" + shortcutProperty.getFullName() + ".");
            }
        }
        return this.resolveAllExplicitProperties(content);
    }

    private DataPropertyBase lookUpInUniqueProperties(String inputContent) {
        DataPropertyBase propertyBase;
        String content = this.maskInput(inputContent);
        DataProperty shortcutFromUnique = this.lookUpShortCutAtStart(content);
        if (shortcutFromUnique != null && !shortcutFromUnique.getPath().isEmpty()) {
            inputContent = content.replaceFirst("#123#<><><>#123#[^.]+\\.", "#123#<><><>#123#" + shortcutFromUnique.getFullName() + ".");
            propertyBase = this.resolve(inputContent);
        } else {
            Optional<Map.Entry> entry = this.uniqueProperties.entrySet().stream().filter(p -> content.contains("#123#<><><>#123#" + ((String)p.getKey()).toLowerCase().replace(" ", "#123#<><><>#123#").replace("_", "#123#<><><>#123#") + "#123#<><><>#123#")).findFirst();
            propertyBase = entry.isPresent() ? (DataPropertyBase)entry.get().getValue() : null;
        }
        return propertyBase;
    }

    private DataProperty lookUpShortCutAtStart(String inputContent) {
        if (inputContent.contains(".")) {
            for (Map.Entry<String, DataProperty> e : this.uniqueProperties.entrySet()) {
                if (!inputContent.contains("#123#<><><>#123#" + e.getKey().toLowerCase() + ".")) continue;
                return e.getValue();
            }
        }
        return null;
    }

    private List<DataProperty> lookUpAllShortCutAtStart(String inputContent) {
        ArrayList<DataProperty> shortCutProperties = new ArrayList<DataProperty>();
        if (inputContent.contains(".")) {
            for (Map.Entry<String, DataProperty> e : this.uniqueProperties.entrySet()) {
                if (!inputContent.contains("#123#<><><>#123#" + e.getKey().toLowerCase() + ".")) continue;
                shortCutProperties.add(e.getValue());
            }
        }
        return shortCutProperties;
    }

    private String maskInput(String input) {
        return "#123#<><><>#123#" + input.toLowerCase().replaceAll(" ", "#123#<><><>#123#").replaceAll("\n", "#123#<><><>#123#").replaceFirst("([^(]*\\()+", "").replaceFirst("(\\)+[^)]*)+", "") + "#123#<><><>#123#";
    }

    public String filterPropertyString(String content) {
        return this.filterPropertyString("", content);
    }

    public String filterPropertyString(String scope, String content) {
        if (content != null && scope != null) {
            String propertyPath = null;
            String scopePrefix = (!scope.isEmpty() ? scope + "." : "").toLowerCase();
            String cnt = this.maskInput(content);
            Optional<DataPropertyBase> prop = this._properties.stream().filter(p -> p.getFullNameLowerCase().startsWith(scopePrefix) && cnt.contains("#123#<><><>#123#" + p.getFullNameLowerCase().replace(scopePrefix, "").replace(" ", "#123#<><><>#123#").replace("_", "#123#<><><>#123#") + "#123#<><><>#123#")).findFirst();
            String string = propertyPath = prop != null && prop.isPresent() ? prop.get().getFullName().substring(scopePrefix.length()) : null;
            if (propertyPath != null) {
                return propertyPath;
            }
            if (scopePrefix.length() == 0) {
                DataPropertyBase uniqueProperty = this.lookUpInUniqueProperties(content);
                propertyPath = uniqueProperty != null ? uniqueProperty.getFullName().substring(scopePrefix.length()) : null;
            }
            return propertyPath;
        }
        return null;
    }

    public void sort() {
        List<String> keys = this._properties.stream().map(p -> p.getFullNameLowerCase()).collect(Collectors.toList());
        keys = keys.stream().sorted(Comparator.comparing(String::length)).collect(Collectors.toList());
        Collections.reverse(keys);
        ArrayList<DataPropertyBase> sorted = new ArrayList<DataPropertyBase>();
        keys.forEach(k -> sorted.add(this.findByFullName((String)k)));
        this._properties = sorted;
    }

    public DataPropertyBase getPropertyIfIsInPath(String part) {
        if (this.getProperties() != null) {
            for (DataProperty prop : this.getProperties()) {
                if (prop.getFullNameAsParts() == null || !Arrays.stream(prop.getFullNameAsParts()).anyMatch(p -> p.equals(part))) continue;
                return prop;
            }
        }
        return null;
    }

    public DataProperty findPropertyByFullName(String fullName) {
        DataPropertyBase prop = this.findByFullName(fullName);
        return prop != null && prop instanceof DataProperty ? (DataProperty)prop : null;
    }

    public DataVariableReference findVariableByFullName(String fullName) {
        DataPropertyBase prop = this.findByFullName(fullName);
        return prop != null && prop instanceof DataVariableReference ? (DataVariableReference)prop : null;
    }

    public DataPropertyBase findByFullName(String fullName) {
        String fl = fullName.toLowerCase();
        Optional<DataPropertyBase> prop = this._properties.stream().filter(p -> p.getFullNameLowerCase().equals(fl)).findFirst();
        return prop != null && prop.isPresent() ? prop.get() : null;
    }

    public DataPropertyBase extract(String name) {
        if (name != null) {
            for (String n : name.split(" ")) {
                DataPropertyBase prop = this.findByFullName(n);
                if (prop == null) continue;
                return prop;
            }
        }
        return null;
    }

    public HashMap<String, DataProperty> getUniqueProperties() {
        return this.uniqueProperties;
    }
}

