/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.exceptions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.utils.StringUtils;

public class ASTValidationException
extends OpenValidationException {
    private int _position = -1;
    private ASTItem item;
    private int errorStart = 0;
    private int errorEnd = 0;

    public ASTValidationException(String message) {
        this(message, (ASTItem)null);
    }

    public ASTValidationException(String message, ASTItem item) {
        super(message);
        this.item = item;
        this.setUserMessage(message);
    }

    public ASTValidationException(String message, ASTItem item, int position) {
        super(message);
        this.item = item;
        this.setUserMessage(message);
        this.setGlobalElementPosition(position);
    }

    public ASTValidationException(String message, ASTItem item, int startError, int lengthError) {
        this(message, item);
        this.setErrorStart(startError);
        this.setErrorLength(lengthError);
        int srcLength = (this.getSource() != null ? this.getSource() : "").length();
        if (this.getErrorStart() > srcLength) {
            this.setErrorStart(this.getSource().length());
        }
        if (this.getErrorStart() < 0) {
            this.setErrorStart(-1);
        }
    }

    @JsonProperty
    public int getErrorStart() {
        return this.errorStart;
    }

    public void setErrorStart(int start) {
        this.errorStart = start;
    }

    @JsonProperty
    public int getErrorLength() {
        return this.errorEnd;
    }

    public void setErrorLength(int length) {
        this.errorEnd = length;
    }

    @JsonProperty
    public String getSource() {
        return this.item != null ? this.item.getPreprocessedSource() : null;
    }

    @JsonProperty
    public String getOriginalSource() {
        return this.item != null ? this.item.getOriginalSource() : null;
    }

    @JsonProperty
    public int getGlobalElementPosition() {
        return this.item != null ? this.item.getGlobalPosition() : this._position;
    }

    @JsonIgnore
    public ASTItem getItem() {
        return this.item;
    }

    public void setGlobalElementPosition(int position) {
        if (this.item != null) {
            this.item.setGlobalPosition(position);
        } else {
            this._position = position;
        }
    }

    @JsonProperty
    public String getErrorSource() {
        String source = this.getSource();
        if (source == null) {
            source = "";
        }
        if (this.getErrorStart() >= source.length()) {
            source = StringUtils.padRight(source, source.length() + this.getErrorLength());
        } else if (this.getErrorStart() < 0) {
            source = StringUtils.padLeft(source, source.length() + this.getErrorLength());
        }
        return source;
    }

    public String underlineError(String error) {
        if (error != null) {
            String out = "";
            if (this.getErrorStart() > 0) {
                out = out + error.substring(0, this.getErrorStart());
                int end = this.getErrorStart() + this.getErrorLength();
                out = error.length() > end ? out + "\u001b[4;31m" + error.substring(this.getErrorStart(), end) + "\u001b[0m" : out + "\u001b[4;31m" + error.substring(this.getErrorStart()) + "\u001b[0m";
                if (end < error.length()) {
                    out = out + error.substring(end);
                }
            } else {
                out = out + "\u001b[4;31m" + error.substring(0, this.getErrorLength()) + "\u001b[0m";
                out = out + error.substring(this.getErrorLength());
            }
            return out;
        }
        return error;
    }

    @JsonProperty
    public String getUnderlinedErrorSource() {
        String error = this.getErrorSource();
        return this.underlineError(error);
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        String uMessage = this.getUserMessage();
        String errorSrc = this.getUnderlinedErrorSource();
        String errorArrow = StringUtils.padLeft("", errorSrc.length());
        int middle = (int)Math.floor(new Double(this.getErrorLength() / 2));
        errorArrow = errorArrow.substring(0, this.getErrorStart() + middle) + "\u2b9d" + errorArrow.substring(this.getErrorStart() + middle);
        sb.append("\u001b[0;37mRULE at Position " + (this.getGlobalElementPosition() + 1) + ":" + "\u001b[0m" + "\n\n");
        sb.append(errorSrc + "\n");
        sb.append("\u001b[0;31m" + errorArrow + "\u001b[0m" + "\n");
        sb.append("\u001b[0;31m" + uMessage + "\u001b[0m" + "\n\n");
        if (verbose) {
            sb.append(super.toString(verbose));
        }
        return sb.toString();
    }
}

