/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.log;

import io.openvalidation.common.log.LogicalTask;
import io.openvalidation.common.log.LogicalTaskState;

public class LogicalProcess
extends LogicalTask {
    public LogicalProcess(String name) {
        super(name, null);
    }

    public LogicalProcess start(String name) {
        LogicalTask task = this.find(name);
        if (task != null) {
            task.State = LogicalTaskState.Started;
        }
        return this;
    }

    public LogicalProcess succeeded(String name) {
        LogicalTask task = this.find(name);
        if (task != null) {
            task.State = LogicalTaskState.Succeeded;
            task.end();
        }
        return this;
    }

    public LogicalProcess errored(String name, String errorMessage, Exception exception) {
        LogicalTask task = this.find(name);
        if (task != null) {
            task.State = LogicalTaskState.Errored;
            task.Message = errorMessage;
            task.Exception = exception;
            task.end();
        }
        return this;
    }

    public LogicalProcess warned(String name, String errorMessage, Exception exception) {
        LogicalTask task = this.find(name);
        if (task != null) {
            task.State = LogicalTaskState.Warned;
            task.Message = errorMessage;
            task.Exception = exception;
            task.end();
        }
        return this;
    }

    public LogicalTaskState getCompleteState() {
        if (this.hasState(LogicalTaskState.Errored)) {
            return LogicalTaskState.Errored;
        }
        if (this.hasState(LogicalTaskState.Warned)) {
            return LogicalTaskState.Warned;
        }
        return LogicalTaskState.Succeeded;
    }
}

