/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.log;

import io.openvalidation.common.log.LogicalProcess;
import io.openvalidation.common.log.LogicalTaskState;
import io.openvalidation.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class LogicalTask {
    public LogicalTask Parent;
    public String Name;
    public LogicalTaskState State;
    public String Message;
    public Exception Exception;
    public int Level = 0;
    public long startDate;
    public long endDate;
    public long msLeft;
    private List<LogicalTask> _subtasks = new ArrayList<LogicalTask>();
    String prefix = "|";
    int spacesPerLevel = 8;

    public LogicalTask(String name, LogicalTask parent) {
        this.State = LogicalTaskState.NotExecuted;
        this.Name = name;
        this.Parent = parent;
        if (this.Parent != null) {
            this.Level = this.Parent.Level + 1;
        }
        this.startDate = System.currentTimeMillis();
    }

    public LogicalTask create(String name) {
        LogicalTask task = new LogicalTask(name, this);
        this._subtasks.add(task);
        return task;
    }

    public LogicalTask append(String name) {
        LogicalTask task = new LogicalTask(name, this);
        this._subtasks.add(task);
        return this;
    }

    public void end() {
        this.endDate = System.currentTimeMillis();
        this.msLeft = this.endDate - this.startDate;
    }

    public LogicalTask find(String name) {
        if (this.Name.toLowerCase().equals(name.toLowerCase())) {
            return this;
        }
        LogicalTask outTask = null;
        for (LogicalTask task : this._subtasks) {
            outTask = task.find(name);
            if (outTask == null) continue;
            return outTask;
        }
        return null;
    }

    public boolean hasState(LogicalTaskState stateToFind) {
        if (this.State == stateToFind) {
            return true;
        }
        for (LogicalTask task : this._subtasks) {
            if (!task.hasState(stateToFind)) continue;
            return true;
        }
        return false;
    }

    public String print() {
        return this.print(true);
    }

    public String getError() {
        if (this.Message != null && this.Message.trim().length() > 0) {
            return " : " + this.Message;
        }
        if (this.Exception != null && this.Exception.getMessage() != null) {
            return " : " + this.Exception.getMessage();
        }
        return "";
    }

    public String print(boolean colored) {
        String spaceArrow;
        StringBuilder sb = new StringBuilder();
        boolean hasNext = this.hasNextItem();
        String leftSpace = this.getLeftPrefix(true);
        String leftSpace2 = leftSpace.substring(0, leftSpace.length() - 1);
        String bottomSpace = hasNext ? leftSpace : leftSpace2 + " ";
        String string = spaceArrow = hasNext ? "|" : "\u2517";
        if (this.Level == 0) {
            sb.append(this.getStateColor(LogicalTaskState.Succeeded, colored) + "  \u250f-----------\u2510\n").append("  |   START   |\n").append("               \n" + this.getResetColor(colored));
        }
        sb.append(this.getStateColor(colored) + leftSpace + "\n").append(leftSpace + "\n").append(leftSpace + "     \u250f---\n").append(leftSpace2 + spaceArrow + "---> |  " + this.Name + " " + Long.toString(this.msLeft) + "ms " + this.getError() + "\n").append(bottomSpace + "     \u2517--------------\n" + this.getResetColor(colored));
        for (LogicalTask task : this._subtasks) {
            sb.append(task.print());
        }
        if (this._subtasks.size() == 0 && !hasNext && this.Level > 0) {
            int levelWithParent = this.Parent.getLevelOfParentWithNext();
            String arrowBackLine = StringUtils.padLeft("-", (this.Level - levelWithParent) * this.spacesPerLevel).replace(" ", "-");
            String arrowBackSpaces = StringUtils.padLeft(" ", (this.Level - levelWithParent) * this.spacesPerLevel + (this.spacesPerLevel + 1));
            String p = leftSpace.trim();
            p = p.endsWith(this.prefix) ? p.substring(0, p.length() - 1) : p;
            String arl = "<" + arrowBackLine + StringUtils.padLeft("-", this.spacesPerLevel).replace(" ", "-") + "\u251b";
            String arrowBack = "       " + p.trim() + arl;
            sb.append("       " + this.getStateColor(colored) + p.trim() + arrowBackSpaces + this.prefix + "\n");
            sb.append(arrowBack + this.getResetColor(colored) + "\n");
        }
        if (this.Level == 0) {
            LogicalTaskState state = LogicalTaskState.Succeeded;
            if (this instanceof LogicalProcess) {
                state = ((LogicalProcess)this).getCompleteState();
            }
            sb.append(this.getStateColor(state, colored) + leftSpace + "\n").append(StringUtils.padLeft(" ", this.spacesPerLevel) + "\n").append("  |    STOP   |\n").append("  \u2517-----------\u251b\n" + this.getResetColor(colored));
        }
        return sb.toString();
    }

    private String getStateColor(boolean colored) {
        return this.getStateColor(this.State, colored);
    }

    private String getResetColor(boolean colored) {
        if (!colored) {
            return "";
        }
        return "\u001b[0m";
    }

    private String getStateColor(LogicalTaskState state, boolean colored) {
        if (!colored) {
            return "";
        }
        switch (state) {
            case NotExecuted: {
                return "\u001b[0m";
            }
            case Warned: {
                return "\u001b[0;33m";
            }
            case Succeeded: {
                return "\u001b[0;32m";
            }
            case Started: {
                return "\u001b[0;33m";
            }
            case Errored: {
                return "\u001b[0;31m";
            }
        }
        return "\u001b[0m";
    }

    private String getLeftPrefix(boolean isRoot) {
        if (this.Level == 0) {
            return StringUtils.padLeft(this.prefix, this.spacesPerLevel);
        }
        String pr = isRoot || this.hasNextItem() ? this.prefix : "";
        String current = StringUtils.padLeft(pr, this.spacesPerLevel);
        return this.Parent.getLeftPrefix(false) + current;
    }

    private boolean hasNextItem() {
        if (this.Parent == null) {
            return true;
        }
        int indx = this.Parent._subtasks.indexOf(this);
        return indx < this.Parent._subtasks.size() - 1;
    }

    private int getLevelOfParentWithNext() {
        if (this.hasNextItem()) {
            return this.Level;
        }
        if (this.Parent != null) {
            return this.Parent.getLevelOfParentWithNext();
        }
        return 0;
    }
}

