/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.log;

import io.openvalidation.common.log.LogicalProcess;
import java.util.HashMap;
import java.util.Map;

public class ProcessLogger {
    private static Map<String, LogicalProcess> _loggers = new HashMap<String, LogicalProcess>();
    public static String CLI = "CLI";
    public static String CLI_PARSE_ARGUMENTS = "CLI - parse arguments";
    public static String CLI_VALIDATE_ARGS = "CLI - validate arguments";
    public static String CLI_INIT_OV_INSTANCE = "CLI - init ov instance";
    public static String PARSER = "PARSER";
    public static String PARSER_MAIN = "PARSER - main";
    public static String PREPROCESSOR = "PREPROCESSOR";
    public static String PREPROCESSOR_RESOLVE_ALIASES = "PREPROCESSOR - resolve aliases";
    public static String PREPROCESSOR_RESOLVE_INCLUDES = "PREPROCESSOR - resolve includes";
    public static String VALIDATOR = "AST VALIDATOR";
    public static String GENERATOR = "CODE GENERATOR";

    public static void initialize() {
        LogicalProcess process = new LogicalProcess(CLI);
        process.append((String)ProcessLogger.CLI_PARSE_ARGUMENTS).append((String)ProcessLogger.CLI_VALIDATE_ARGS).append((String)ProcessLogger.CLI_INIT_OV_INSTANCE).create((String)ProcessLogger.PREPROCESSOR).append((String)ProcessLogger.PREPROCESSOR_RESOLVE_INCLUDES).append((String)ProcessLogger.PREPROCESSOR_RESOLVE_ALIASES).Parent.create((String)ProcessLogger.PARSER).append((String)ProcessLogger.PARSER_MAIN).Parent.create((String)ProcessLogger.VALIDATOR).Parent.append(GENERATOR);
        _loggers.put(ProcessLogger.getThreadID(), process);
    }

    public static void error(String name) {
        ProcessLogger.error(name, null, null);
    }

    public static void error(String name, String message) {
        ProcessLogger.error(name, message, null);
    }

    public static void error(String name, Exception e) {
        ProcessLogger.error(name, null, e);
    }

    public static void error(String name, String message, Exception exp) {
        LogicalProcess process = ProcessLogger.getCurrentProcess();
        if (process != null) {
            process.errored(name, message, exp);
        }
    }

    public static void warning(String name) {
        ProcessLogger.warning(name, null);
    }

    public static void warning(String name, String message) {
        ProcessLogger.warning(name, message, null);
    }

    public static void warning(String name, String message, Exception exp) {
        LogicalProcess process = ProcessLogger.getCurrentProcess();
        if (process != null) {
            process.warned(name, message, exp);
        }
    }

    public static void success(String name) {
        LogicalProcess process = ProcessLogger.getCurrentProcess();
        if (process != null) {
            process.succeeded(name);
        }
    }

    public static String print() {
        LogicalProcess process = ProcessLogger.getCurrentProcess();
        return process != null ? process.print() : "";
    }

    private static String getThreadID() {
        return "" + Thread.currentThread().getId();
    }

    private static LogicalProcess getCurrentProcess() {
        return _loggers.get(ProcessLogger.getThreadID());
    }
}

