/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.model;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.model.CodeKind;

public class CodeGenerationResult {
    private String _name;
    private String _id;
    private String _code;
    private ASTModel _ast;
    private String _preprocessedRule;
    private CodeKind _codeKind;
    private String _codeFileName;

    public CodeGenerationResult(ASTModel ast, String code) {
        this._code = code;
        this._ast = ast;
    }

    public String getCode() {
        return this._code;
    }

    public void setCode(String _code) {
        this._code = _code;
    }

    public ASTModel getAST() {
        return this._ast;
    }

    public void setAST(ASTModel ast) {
        this._ast = ast;
    }

    public CodeKind getCodeKind() {
        return this._codeKind;
    }

    public void setCodeKind(CodeKind codeKind) {
        this._codeKind = codeKind;
    }

    public String getName() {
        return this._name;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public static CodeGenerationResult createFrameworkResult(ASTModel ast, String code) {
        CodeGenerationResult result = new CodeGenerationResult(ast, code);
        result.setCodeKind(CodeKind.Framework);
        result.setName("HUMLFramework");
        return result;
    }

    public static CodeGenerationResult createValidatorFactoryResult(String code) {
        CodeGenerationResult result = new CodeGenerationResult(null, code);
        result.setCodeKind(CodeKind.ValidatorFactory);
        result.setName("OpenValidatorFactory");
        return result;
    }

    public static CodeGenerationResult createImplementation(ASTModel ast, String code) {
        CodeGenerationResult result = new CodeGenerationResult(ast, code);
        result.setCodeKind(CodeKind.Implementation);
        return result;
    }

    public static CodeGenerationResult createCombined(ASTModel ast, String code) {
        CodeGenerationResult result = new CodeGenerationResult(ast, code);
        result.setCodeKind(CodeKind.Combined);
        return result;
    }

    public String getPreprocessedRule() {
        return this._preprocessedRule;
    }

    public void setPreprocessedRule(String preprocessedRule) {
        this._preprocessedRule = preprocessedRule;
    }

    public String getCodeFileName() {
        return this._codeFileName;
    }

    public void setCodeFileName(String _codeFileName) {
        this._codeFileName = _codeFileName;
    }
}

