/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.model;

import io.openvalidation.common.model.Language;
import io.openvalidation.common.utils.JsonUtils;
import io.openvalidation.common.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.json.JSONObject;

public class Languages {
    private static Languages singleInstance;
    private List<Language> languages;

    private Languages() {
        String json = ResourceUtils.getResourceConent("languages.json", this.getClass());
        JSONObject languagesJson = JsonUtils.loadJson(json);
        this.languages = new ArrayList<Language>();
        languagesJson.keys().forEachRemaining(language -> this.languages.add(new Language((String)language, languagesJson.getJSONObject(language))));
    }

    private static Languages getInstance() {
        if (singleInstance == null) {
            singleInstance = new Languages();
        }
        return singleInstance;
    }

    public static Language getLanguage(String name) {
        return Languages.getInstance().languages.stream().filter(language -> name.toLowerCase().equals(language.getName().toLowerCase())).findAny().orElse(null);
    }

    public static Stream<Language> getLanguageStream() {
        return Languages.getInstance().languages.stream();
    }
}

