/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.model;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.exceptions.ASTValidationSummaryException;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.model.CodeGenerationResult;
import io.openvalidation.common.model.CodeKind;
import io.openvalidation.common.utils.Console;
import io.openvalidation.common.utils.LINQ;
import io.openvalidation.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenValidationResult {
    private List<CodeGenerationResult> _results = new ArrayList<CodeGenerationResult>();
    private List<OpenValidationException> _exceptions = new ArrayList<OpenValidationException>();
    private ASTModel _model;
    private String _preprocessedRule = "";
    private String _plainRule = "";

    public List<CodeGenerationResult> getResults() {
        return this._results;
    }

    public void addResult(CodeGenerationResult result) {
        this._results.add(result);
        if (result.getAST() != null && this.getASTModel() == null) {
            this.setASTModel(result.getAST());
        }
        if (result.getPreprocessedRule() != null && this.getPreprocessedRule() == null) {
            this.setPreprocessedRule(result.getPreprocessedRule());
        }
    }

    public void addResults(List<CodeGenerationResult> results) {
        this._results.addAll(results);
    }

    public void addError(OpenValidationException exp) {
        this._exceptions.add(exp);
    }

    public void addErrors(List<OpenValidationException> exps) {
        this._exceptions.addAll(exps);
    }

    public List<OpenValidationException> getErrors() {
        return this._exceptions;
    }

    public List<String> getAllErrorMessages() {
        return this.getErrors().stream().filter(e -> e.getUserMessage() != null).map(e -> e.getUserMessage()).collect(Collectors.toList());
    }

    public List<String> getAllValidationErrorMessages() {
        return this.getValidationErros().stream().filter(e -> e.getUserMessage() != null).map(e -> e.getUserMessage()).collect(Collectors.toList());
    }

    public List<ASTValidationException> getValidationErros() {
        List<ASTValidationException> errors = LINQ.ofType(this._exceptions, ASTValidationException.class);
        List<ASTValidationSummaryException> summaryExceptions = LINQ.ofType(this._exceptions, ASTValidationSummaryException.class);
        List summaryErrors = summaryExceptions.stream().filter(e -> e.hasErrors()).flatMap(e -> e.getErrors().stream()).collect(Collectors.toList());
        errors.addAll(summaryErrors);
        return errors;
    }

    public boolean hasErrors() {
        return this._exceptions.size() > 0;
    }

    public String getAllCodeContent() {
        return String.join((CharSequence)"\n", this.getResults().stream().map(r -> r.getCode()).collect(Collectors.toList()));
    }

    public String getImplementationCodeContent() {
        return String.join((CharSequence)"\n", this.getImplementationResults().stream().map(r -> r.getCode()).collect(Collectors.toList()));
    }

    public CodeGenerationResult getFrameworkResult() {
        Optional<CodeGenerationResult> res = this.getResults().stream().filter(r -> r.getCodeKind() == CodeKind.Framework).findFirst();
        return res.isPresent() ? res.get() : null;
    }

    public List<CodeGenerationResult> getImplementationResults() {
        return this.getResults().stream().filter(r -> r.getCodeKind() == CodeKind.Implementation || r.getCodeKind() == CodeKind.Combined).collect(Collectors.toList());
    }

    public CodeGenerationResult getValidatorFactoryResult() {
        Optional<CodeGenerationResult> res = this.getResults().stream().filter(r -> r.getCodeKind() == CodeKind.ValidatorFactory).findFirst();
        return res.isPresent() ? res.get() : null;
    }

    public static OpenValidationResult createErrorResult(Exception exp) {
        OpenValidationResult result = new OpenValidationResult();
        result.addError(new OpenValidationException("", exp));
        return result;
    }

    public static OpenValidationResult createErrorResult(String errorMessage) {
        OpenValidationResult result = new OpenValidationResult();
        result.addError(new OpenValidationException(errorMessage));
        return result;
    }

    public void setASTModel(ASTModel model) {
        this._model = model;
    }

    public ASTModel getASTModel() {
        if (this._model == null && this._results != null && this._results.size() > 0) {
            this._model = this._results.get(0).getAST();
        }
        return this._model;
    }

    public List<String> getCreatedFiles() {
        return LINQ.select(this.getResults(), r -> r.getCodeFileName());
    }

    public void setPreprocessedRule(String rule) {
        this._preprocessedRule = rule;
    }

    public String getPreprocessedRule() {
        return this._preprocessedRule;
    }

    public void setPlainRule(String rule) {
        this._plainRule = rule;
    }

    public String getPlainRule() {
        return this._plainRule;
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (verbose) {
            sb.append(this.getASTModelPrint());
            sb.append("\u001b[0;37m\nPLAIN RULE \u2b9f \n\n\u001b[0m" + this._plainRule + "\n\n");
            String preprrul = this._preprocessedRule != null ? this._preprocessedRule.replaceAll("\u02acparagraph\u02ac", "\n\n\u02acparagraph\u02ac\n\n") : "";
            sb.append("\u001b[0;37m\nPREPROCESSED RULE \u2b9f \n\n\u001b[0m" + preprrul + "\n\n");
        }
        return sb.toString();
    }

    public String getErrorPrint(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        this._exceptions.forEach(e -> sb.append(e.toString(verbose)));
        return sb.toString();
    }

    public String getASTModelPrint() {
        if (this._model != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(Console.getTitleStart("AST MODEL"));
            sb.append(this._model.print());
            sb.append("\n\n\n");
            return sb.toString();
        }
        return "";
    }

    public String getRuleSetPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(Console.getTitleStart("PLAIN RULE"));
        sb.append(this.getPlainRule() + "\n");
        sb.append(Console.getTitleStart("PREPROCESSED RULE"));
        sb.append(this.getPreprocessedRule() + "\n\n");
        return sb.toString();
    }

    public String getCreatedFilesPrint() {
        StringBuilder sb = new StringBuilder();
        if (this.getCreatedFiles().size() > 0) {
            sb.append(Console.getTitleStart("CREATED FILES"));
            sb.append(String.join((CharSequence)"\n", this.getCreatedFiles()) + "\n\n");
        }
        return sb.toString();
    }

    public String getSummaryPrint() {
        return this.getSummaryPrint("");
    }

    public String getSummaryPrint(String name) {
        StringBuilder sb = new StringBuilder();
        ASTModel model = this.getASTModel();
        String factoryRes = this.getValidatorFactoryResult() != null ? "1" : "0";
        String factoryResState = this.getValidatorFactoryResult() != null ? Console.successString("SUCCESS") : Console.grayString("SKIPPED");
        String frameworkRes = this.getFrameworkResult() != null ? "1" : "0";
        String frameworkResState = this.getFrameworkResult() != null ? Console.successString("SUCCESS") : Console.grayString("SKIPPED");
        int implementationResults = this.getImplementationResults() != null ? this.getImplementationResults().size() : 0;
        String implementationResState = implementationResults > 0 ? Console.successString("SUCCESS") : Console.errorString("FAILED");
        int variablesResults = model != null && model.getVariables() != null ? model.getVariables().size() : 0;
        String variablesResState = variablesResults > 0 ? Console.successString("SUCCESS") : Console.grayString("SKIPPED");
        int rulesResults = model != null && model.getRules() != null ? model.getRules().size() : 0;
        String rulesResState = rulesResults > 0 ? Console.successString("SUCCESS") : Console.errorString("FAILED");
        int errorsResults = this.getErrors() != null ? this.getErrors().size() : 0;
        String errorsResState = errorsResults > 0 ? Console.errorString("FAILED") : Console.successString("SUCCESS");
        int filesResults = this.getCreatedFiles().size();
        String filesResState = filesResults > 0 ? Console.successString("SUCCESS") : Console.grayString("SKIPPED");
        String summaryName = "code generation summary";
        if (!StringUtils.isNullOrEmpty(name)) {
            summaryName = summaryName + " : " + name;
        }
        if (model != null) {
            sb.append(Console.grayString("\n\n------------    " + summaryName + "    ------------\n\n")).append("Rules  " + Console.grayString("................................  ") + StringUtils.padLeft(rulesResults, 4) + "  " + rulesResState + "\n").append("Variables  " + Console.grayString("............................  ") + StringUtils.padLeft(variablesResults, 4) + "  " + variablesResState + "\n").append("Implementation  " + Console.grayString(".......................  ") + StringUtils.padLeft(implementationResults, 4) + "  " + implementationResState + "\n").append("Framework  " + Console.grayString("............................  ") + StringUtils.padLeft(frameworkRes, 4) + "  " + frameworkResState + "\n").append("Factory  " + Console.grayString("..............................  ") + StringUtils.padLeft(factoryRes, 4) + "  " + factoryResState + "\n").append("Files created  " + Console.grayString("........................  ") + StringUtils.padLeft(filesResults, 4) + "  " + filesResState + "\n").append("Errors  " + Console.grayString("...............................  ") + StringUtils.padLeft(errorsResults, 4) + "  " + errorsResState + "\n").append(Console.grayString("\n-------------------------------------------------------\n")).append("\n\n\n");
        }
        return sb.toString();
    }
}

